/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.api.tfenergy;

import baguchan.tofucraft.api.tfenergy.ITofuEnergy;
import baguchan.tofucraft.api.tfenergy.TofuNetworkChangedEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.LevelEvent;

@EventBusSubscriber
public class TofuNetwork {
    public static final TofuNetwork Instance = new TofuNetwork();
    private HashMap<String, BlockEntity> reference = new HashMap();

    public static List<String> toUUIDs(Stream<Map.Entry<String, BlockEntity>> map) {
        ArrayList<String> uids = new ArrayList<String>();
        map.forEach(entry -> uids.add((String)entry.getKey()));
        return uids;
    }

    public static List<BlockEntity> toTiles(Stream<Map.Entry<String, BlockEntity>> map) {
        ArrayList<BlockEntity> tes = new ArrayList<BlockEntity>();
        map.forEach(entry -> tes.add((BlockEntity)entry.getValue()));
        return tes;
    }

    @SubscribeEvent
    public static void onUnloadLevel(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        for (String uid : TofuNetwork.toUUIDs(Instance.getTEWithinDim(world.dimensionType()))) {
            Instance.unload(uid, true);
        }
    }

    public BlockEntity find(String uid) {
        return this.reference.get(uid);
    }

    public void register(String uid, BlockEntity te) {
        this.register(uid, te, false);
    }

    public void register(String uid, BlockEntity te, boolean isSystem) {
        if (!(te instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("Can't register machine which is not Tofu Energy Tile!");
        }
        this.reference.put(uid, te);
        NeoForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkLoaded(uid, te, isSystem));
    }

    public HashMap<String, BlockEntity> getReference() {
        return this.reference;
    }

    public Stream<Map.Entry<String, BlockEntity>> getTEWithinDim(DimensionType dimid) {
        return this.reference.entrySet().stream().filter(entry -> ((BlockEntity)entry.getValue()).getLevel().dimensionType().equals((Object)dimid));
    }

    public Stream<Map.Entry<String, BlockEntity>> getTEWithinRadius(Level world, BlockPos pos, double radius) {
        return this.getTEWithinDim(world.dimensionType()).filter(entry -> (double)((BlockEntity)entry.getValue()).getBlockPos().distManhattan((Vec3i)pos) <= radius);
    }

    public Stream<Map.Entry<String, BlockEntity>> getTEWithinRadius(BlockEntity center, double radius) {
        BlockPos pos = center.getBlockPos();
        return this.getTEWithinDim(center.getLevel().dimensionType()).filter(entry -> (double)((BlockEntity)entry.getValue()).getBlockPos().distManhattan((Vec3i)pos) <= radius);
    }

    public Stream<Map.Entry<String, BlockEntity>> getExtractableWithinRadius(Level world, BlockPos pos, double radius) {
        return this.getTEWithinRadius(world, pos, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canDrain(null));
    }

    public Stream<Map.Entry<String, BlockEntity>> getExtractableWithinRadius(BlockEntity center, double radius) {
        if (!(center instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("The center tile is not able to transfer energy!");
        }
        return this.getTEWithinRadius(center, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canDrain(center) && ((ITofuEnergy)center).canReceive((BlockEntity)entry.getValue()));
    }

    public Stream<Map.Entry<String, BlockEntity>> getInsertableWithinRadius(Level world, BlockPos pos, double radius) {
        return this.getTEWithinRadius(world, pos, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canReceive(null));
    }

    public Stream<Map.Entry<String, BlockEntity>> getInsertableWithinRadius(BlockEntity center, double radius) {
        if (!(center instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("The center tile is not able to transfer energy!");
        }
        return this.getTEWithinRadius(center, radius).filter(entry -> ((ITofuEnergy)entry.getValue()).canReceive(center) && ((ITofuEnergy)center).canDrain((BlockEntity)entry.getValue()));
    }

    public void unload(String uid) {
        this.unload(uid, false);
    }

    public void unload(String uid, boolean isSystem) {
        this.reference.remove(uid);
        NeoForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkRemoved(uid, this.reference.get(uid), isSystem));
    }

    public void clear() {
        this.clear(false);
    }

    public void clear(boolean isSystem) {
        this.reference.clear();
        NeoForge.EVENT_BUS.post((Event)new TofuNetworkChangedEvent.NetworkCleared(isSystem));
    }
}

