/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.block;

import baguchan.tofucraft.registry.TofuBlocks;
import baguchan.tofucraft.registry.TofuItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.Tags;

public class YubaBlock
extends Block {
    private static final VoxelShape STABLE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);

    public YubaBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)TofuItems.YUBA.get());
    }

    public VoxelShape getShape(BlockState p_56057_, BlockGetter p_56058_, BlockPos p_56059_, CollisionContext p_56060_) {
        return STABLE_SHAPE;
    }

    public VoxelShape getInteractionShape(BlockState p_56053_, BlockGetter p_56054_, BlockPos p_56055_) {
        return STABLE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState p_56068_, BlockGetter p_56069_, BlockPos p_56070_, CollisionContext p_56071_) {
        if (p_56071_.isAbove(STABLE_SHAPE, p_56070_, true)) {
            return STABLE_SHAPE;
        }
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState p_152289_, LevelReader p_152290_, BlockPos p_152291_) {
        BlockPos blockpos = p_152291_.below();
        BlockState blockstate = p_152290_.getBlockState(blockpos);
        return blockstate.is((Block)TofuBlocks.SOYMILK.get()) || blockstate.isFaceSturdy((BlockGetter)p_152290_, blockpos, Direction.UP);
    }

    public BlockState updateShape(BlockState p_152293_, Direction p_152294_, BlockState p_152295_, LevelAccessor p_152296_, BlockPos p_152297_, BlockPos p_152298_) {
        if (!p_152296_.isClientSide()) {
            p_152296_.scheduleTick(p_152297_, (Block)this, 5);
        }
        return p_152293_;
    }

    public void entityInside(BlockState state, Level level, BlockPos blockPos, Entity entity) {
        super.entityInside(state, level, blockPos, entity);
        if (!level.isClientSide() && YubaBlock.canEntityTilt(blockPos, entity)) {
            level.scheduleTick(blockPos, (Block)this, 5);
        }
    }

    private static boolean canEntityTilt(BlockPos p_152302_, Entity p_152303_) {
        return p_152303_.onGround() && p_152303_.position().y > (double)p_152302_.getY() + 0.0625 && p_152303_.position().y <= (double)p_152302_.getY() + 0.125;
    }

    public void tick(BlockState p_222945_, ServerLevel p_222946_, BlockPos p_222947_, RandomSource p_222948_) {
        super.tick(p_222945_, p_222946_, p_222947_, p_222948_);
        if (!this.canSurvive(p_222945_, (LevelReader)p_222946_, p_222947_)) {
            FallingBlockEntity.fall((Level)p_222946_, (BlockPos)p_222947_, (BlockState)p_222945_);
        } else if (!p_222945_.isFaceSturdy((BlockGetter)p_222946_, p_222947_, Direction.UP) && p_222945_.is((Block)TofuBlocks.SOYMILK.get())) {
            p_222946_.levelEvent(2001, p_222947_, Block.getId((BlockState)p_222946_.getBlockState(p_222947_)));
            p_222946_.removeBlock(p_222947_, false);
        }
    }

    protected ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_316140_) {
        if (itemstack.is(Tags.Items.RODS_WOODEN)) {
            if (!worldIn.isClientSide()) {
                ItemStack salt = new ItemStack((ItemLike)TofuItems.YUBA.get(), 1);
                float f = 0.7f;
                double d0 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.2 + 0.2;
                double d2 = (double)(worldIn.random.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                ItemEntity itemEntity = new ItemEntity(worldIn, (double)pos.getX() + d0, (double)pos.getY() + d1, (double)pos.getZ() + d2, salt);
                itemEntity.setPickUpDelay(10);
                worldIn.addFreshEntity((Entity)itemEntity);
                worldIn.removeBlock(pos, false);
            }
            player.playSound(SoundEvents.BOAT_PADDLE_WATER, 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }
}

