/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.client.model;

import baguchan.tofucraft.client.animation.definitions.TofuGolemAnimation;
import baguchan.tofucraft.entity.TofuGolem;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TofuGolemModel<T extends TofuGolem>
extends HierarchicalModel<T> {
    private final ModelPart roots;

    public TofuGolemModel(ModelPart root) {
        this.roots = root.getChild("roots");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition roots = partdefinition.addOrReplaceChild("roots", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)14.0f, (float)0.0f));
        PartDefinition body = roots.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-5.0f, 4.0f, -5.0f, 10.0f, 10.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 40).addBox(-3.0f, 14.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition slab = body.addOrReplaceChild("slab", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, -2.0f, -10.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)5.0f));
        PartDefinition handR = body.addOrReplaceChild("handR", CubeListBuilder.create().texOffs(41, 16).addBox(-3.0f, -1.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)7.0f, (float)0.0f));
        PartDefinition handL = body.addOrReplaceChild("handL", CubeListBuilder.create().texOffs(41, 16).mirror().addBox(0.0f, -1.0f, -2.0f, 3.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)5.0f, (float)7.0f, (float)0.0f));
        PartDefinition mouth = body.addOrReplaceChild("mouth", CubeListBuilder.create().texOffs(30, 0).addBox(-1.5f, -1.75f, -3.0f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)-5.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(((TofuGolem)((Object)entity)).spitAnimationState, TofuGolemAnimation.spit, ageInTicks, 1.0f);
        this.animate(((TofuGolem)((Object)entity)).idleAnimationState, TofuGolemAnimation.idle, ageInTicks, 1.0f);
    }

    public ModelPart root() {
        return this.roots;
    }
}

