/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.compat.jei;

import baguchan.tofucraft.compat.jei.JEIPlugin;
import baguchan.tofucraft.recipe.TofuPotRecipe;
import baguchan.tofucraft.registry.TofuBlocks;
import java.util.Iterator;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class TofuPotCategory
implements IRecipeCategory<TofuPotRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"tofu_pot");
    protected final IDrawableAnimated arrow;
    private final Component title = Component.translatable((String)"tofucraft.jei.tofu_pot");
    private final IDrawable background;
    private final IDrawable icon;

    public TofuPotCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tofu_pot.png");
        this.background = helper.createDrawable(backgroundImage, 37, 4, 112, 79);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)TofuBlocks.TOFU_POT.get()));
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getRegistryName(TofuPotRecipe recipe) {
        return UID;
    }

    public RecipeType<TofuPotRecipe> getRecipeType() {
        return JEIPlugin.TOFU_POT_RECIPE_JEI_TYPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TofuPotRecipe recipe, IFocusGroup focuses) {
        NonNullList recipeIngredients = recipe.getIngredients();
        int startX = 8;
        int startY = 18;
        int inputStartX = 7;
        int inputStartY = 4;
        int borderSlotSize = 18;
        Iterator ingredients = recipeIngredients.iterator();
        int sizeWidth = 3;
        int sizeHeight = 4;
        for (int row = 0; row < sizeHeight; ++row) {
            for (int column = 0; column < sizeWidth && ingredients.hasNext(); ++column) {
                builder.addSlot(RecipeIngredientRole.INPUT, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize).addIngredients((Ingredient)ingredients.next());
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 93, 33).addItemStack(recipe.getResult());
        if (recipe.fluidIngredient().isPresent()) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 93, 15).addFluidStack(recipe.fluidIngredient().get().getFluids()[0].getFluid(), (long)recipe.fluidIngredient().get().amount());
        }
    }

    public void draw(TofuPotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.arrow.draw(stack, 66, 34);
    }
}

