/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.data.generator;

import baguchan.tofucraft.TofuCraftReload;
import baguchan.tofucraft.registry.TofuBannerPatterns;
import baguchan.tofucraft.registry.TofuPoiTypes;
import baguchan.tofucraft.registry.TofuSounds;
import baguchan.tofucraft.registry.TofuTags;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.PoiTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CustomTagGenerator {

    public static class SoundEventTagGenerator
    extends TagsProvider<SoundEvent> {
        public SoundEventTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.SOUND_EVENT, provider, "tofucraft", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TofuTags.SoundEvents.BOSS_MUSIC).add(TofuSounds.TOFU_DUNGEON_BGM.getKey());
        }
    }

    public static class PoiTypeTagGenerator
    extends TagsProvider<PoiType> {
        public PoiTypeTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.POINT_OF_INTEREST_TYPE, provider, "tofucraft", existingFileHelper);
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TofuTags.PoiTypes.TOFU_VILLAGE).add(TofuPoiTypes.TOFUNIAN_STATUE);
            this.tag(PoiTypeTags.ACQUIRABLE_JOB_SITE).add(TofuPoiTypes.TOFU_CRAFTSMAN);
        }
    }

    public static class BannerPatternTagGenerator
    extends TagsProvider<BannerPattern> {
        public static final TagKey<BannerPattern> TOFUNIAN_BANNER_PATTERN = BannerPatternTagGenerator.create("pattern_item/tofunian");

        public BannerPatternTagGenerator(PackOutput output, CompletableFuture<HolderLookup.Provider> provider, @Nullable ExistingFileHelper existingFileHelper) {
            super(output, Registries.BANNER_PATTERN, provider, "tofucraft", existingFileHelper);
        }

        private static TagKey<BannerPattern> create(String name) {
            return TagKey.create((ResourceKey)Registries.BANNER_PATTERN, (ResourceLocation)TofuCraftReload.prefix(name));
        }

        protected void addTags(HolderLookup.Provider p_256380_) {
            this.tag(TOFUNIAN_BANNER_PATTERN).add(TofuBannerPatterns.TOFUNIAN);
        }

        public String getName() {
            return "Tofucraft Banner Pattern Tags";
        }
    }
}

