/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity;

import baguchan.tofucraft.entity.AbstractTofunian;
import baguchan.tofucraft.entity.ShuDofuSpider;
import baguchan.tofucraft.entity.TofuGandlem;
import baguchan.tofucraft.entity.goal.LookAtTofunianTradingPlayerGoal;
import baguchan.tofucraft.entity.goal.TofunianTradeWithPlayerGoal;
import baguchan.tofucraft.registry.TofuItems;
import baguchan.tofucraft.registry.TofuSounds;
import baguchan.tofucraft.registry.TofunianTrades;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.UseItemGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TravelerTofunian
extends AbstractTofunian {
    private static final int NUMBER_OF_TRADE_OFFERS = 5;
    @javax.annotation.Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;

    public TravelerTofunian(EntityType<? extends TravelerTofunian> p_35843_, Level p_35844_) {
        super(p_35843_, p_35844_);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new UseItemGoal((Mob)this, PotionContents.createItemStack((Item)Items.POTION, (Holder)Potions.INVISIBILITY), TofuSounds.TOFUNIAN_YES.get(), p_35882_ -> this.level().isNight() && !p_35882_.isInvisible()));
        this.goalSelector.addGoal(0, (Goal)new UseItemGoal((Mob)this, new ItemStack((ItemLike)Items.MILK_BUCKET), TofuSounds.TOFUNIAN_YES.get(), p_35880_ -> this.level().isDay() && p_35880_.isInvisible()));
        this.goalSelector.addGoal(1, (Goal)new TofunianTradeWithPlayerGoal(this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 1.2, 1.2));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, AbstractIllager.class, 12.0f, 1.2, 1.2));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, EnderMan.class, 12.0f, 1.2, 1.2));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 1.2, 1.2));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 1.2, 1.2));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, ShuDofuSpider.class, 10.0f, 1.2, 1.3));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, TofuGandlem.class, 10.0f, 1.2, 1.3));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(1, (Goal)new LookAtTofunianTradingPlayerGoal(this));
        this.goalSelector.addGoal(2, (Goal)new WanderToPositionGoal(this, 2.0, 1.2));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.1));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @javax.annotation.Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_150046_, AgeableMob p_150047_) {
        return null;
    }

    @Override
    public boolean showProgressBar() {
        return false;
    }

    public InteractionResult mobInteract(Player p_35856_, InteractionHand p_35857_) {
        ItemStack itemstack = p_35856_.getItemInHand(p_35857_);
        if (!itemstack.is((Item)TofuItems.TRAVELER_TOFUNIAN_SPAWNEGG.get()) && this.isAlive() && !this.isTrading() && !this.isBaby()) {
            if (p_35857_ == InteractionHand.MAIN_HAND) {
                p_35856_.awardStat(Stats.TALKED_TO_VILLAGER);
            }
            if (this.getOffers().isEmpty()) {
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
            }
            if (!this.level().isClientSide) {
                this.setTradingPlayer(p_35856_);
                this.openTradingScreen(p_35856_, this.getDisplayName(), 1);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(p_35856_, p_35857_);
    }

    @Override
    protected void updateTrades() {
        VillagerTrades.ItemListing[] avillagertrades$itemlisting = (VillagerTrades.ItemListing[])TofunianTrades.TRAVELER_TOFUNIAN_TRADE.get(1);
        VillagerTrades.ItemListing[] avillagertrades$itemlisting1 = (VillagerTrades.ItemListing[])TofunianTrades.TRAVELER_TOFUNIAN_TRADE.get(2);
        if (avillagertrades$itemlisting != null && avillagertrades$itemlisting1 != null) {
            MerchantOffers merchantoffers = this.getOffers();
            this.addOffersFromItemListings(merchantoffers, avillagertrades$itemlisting, 3);
            this.addOffersFromItemListings(merchantoffers, avillagertrades$itemlisting1, 5);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag p_35861_) {
        super.addAdditionalSaveData(p_35861_);
        p_35861_.putInt("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            p_35861_.put("WanderTarget", NbtUtils.writeBlockPos((BlockPos)this.wanderTarget));
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag p_35852_) {
        super.readAdditionalSaveData(p_35852_);
        if (p_35852_.contains("DespawnDelay", 99)) {
            this.despawnDelay = p_35852_.getInt("DespawnDelay");
        }
        if (p_35852_.contains("WanderTarget")) {
            this.wanderTarget = NbtUtils.readBlockPos((CompoundTag)p_35852_, (String)"WanderTarget").orElse(null);
        }
        this.setAge(Math.max(0, this.getAge()));
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_35282_, DifficultyInstance p_35283_, MobSpawnType p_35284_, @Nullable SpawnGroupData p_35285_) {
        RandomSource randomsource = p_35282_.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, p_35283_);
        return super.finalizeSpawn(p_35282_, p_35283_, p_35284_, p_35285_);
    }

    protected void populateDefaultEquipmentSlots(RandomSource p_217055_, DifficultyInstance p_217056_) {
        if (p_217055_.nextFloat() < 0.1f + p_217056_.getEffectiveDifficulty() * 0.01f) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
            this.setDropChance(EquipmentSlot.FEET, 0.0f);
        } else if (p_217055_.nextFloat() < 0.25f) {
            this.setItemSlot(EquipmentSlot.FEET, new ItemStack(TofuItems.TOFU_MOMEN_BOOTS));
            this.setDropChance(EquipmentSlot.FEET, 0.0f);
        }
    }

    @Override
    public boolean removeWhenFarAway(double p_35886_) {
        return false;
    }

    @Override
    protected void rewardTradeXp(MerchantOffer p_35859_) {
        if (p_35859_.shouldRewardExp()) {
            int i = 3 + this.random.nextInt(4);
            this.level().addFreshEntity((Entity)new ExperienceOrb(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), i));
        }
    }

    public void setDespawnDelay(int p_35892_) {
        this.despawnDelay = p_35892_;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.isTrading() && --this.despawnDelay == 0) {
            this.discard();
        }
    }

    public void setWanderTarget(@javax.annotation.Nullable BlockPos p_35884_) {
        this.wanderTarget = p_35884_;
    }

    @javax.annotation.Nullable
    BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    class WanderToPositionGoal
    extends Goal {
        final TravelerTofunian trader;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(TravelerTofunian p_35899_, double p_35900_, double p_35901_) {
            this.trader = p_35899_;
            this.stopDistance = p_35900_;
            this.speedModifier = p_35901_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public void stop() {
            this.trader.setWanderTarget(null);
            TravelerTofunian.this.navigation.stop();
        }

        public boolean canUse() {
            BlockPos blockpos = this.trader.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void tick() {
            BlockPos blockpos = this.trader.getWanderTarget();
            if (blockpos != null && TravelerTofunian.this.navigation.isDone()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vec3 = new Vec3((double)blockpos.getX() - this.trader.getX(), (double)blockpos.getY() - this.trader.getY(), (double)blockpos.getZ() - this.trader.getZ()).normalize();
                    Vec3 vec31 = vec3.scale(10.0).add(this.trader.getX(), this.trader.getY(), this.trader.getZ());
                    TravelerTofunian.this.navigation.moveTo(vec31.x, vec31.y, vec31.z, this.speedModifier);
                } else {
                    TravelerTofunian.this.navigation.moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_35904_, double p_35905_) {
            return !p_35904_.closerToCenterThan((Position)this.trader.position(), p_35905_);
        }
    }
}

