/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.goal;

import baguchan.tofucraft.entity.Tofunian;
import baguchan.tofucraft.registry.TofuPoiTypes;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.level.LevelReader;

public class FindStatueBlockGoal
extends MoveToBlockGoal {
    public static final Predicate<Holder<PoiType>> STATUE_POI = p_238239_ -> p_238239_.is(TofuPoiTypes.TOFUNIAN_STATUE);
    private final Tofunian creature;
    private boolean findBlock;
    private ResourceKey<PoiType> poiTypeResourceKey;

    public FindStatueBlockGoal(Tofunian creature, double speedIn, int length) {
        super((PathfinderMob)creature, speedIn, length);
        this.creature = creature;
    }

    public boolean canUse() {
        return this.creature.getVillageCenter() == null && super.canUse();
    }

    public boolean canContinueToUse() {
        return !this.findBlock && super.canContinueToUse() && this.mob != null;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget() && this.poiTypeResourceKey != null && !this.findBlock && this.creature.level() instanceof ServerLevel) {
            ((ServerLevel)this.creature.level()).getPoiManager().getType(this.blockPos).ifPresent(p_217105_ -> {
                ((ServerLevel)this.creature.level()).getPoiManager().take(poiTypeHolder -> poiTypeHolder == BuiltInRegistries.POINT_OF_INTEREST_TYPE.getHolder(this.poiTypeResourceKey).get(), (p_217108_, p_217109_) -> p_217109_.equals((Object)this.blockPos), this.blockPos, 1);
                DebugPackets.sendPoiTicketCountPacket((ServerLevel)((ServerLevel)this.creature.level()), (BlockPos)this.blockPos);
                this.creature.setVillageCenter(this.blockPos);
                this.findBlock = true;
                this.creature.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 0.7f);
            });
        }
    }

    protected boolean findNearestBlock() {
        Set set;
        if (this.creature.level() instanceof ServerLevel && !(set = ((ServerLevel)this.creature.level()).getPoiManager().findAllClosestFirstWithType(STATUE_POI, predicate -> true, this.creature.blockPosition(), 48, PoiManager.Occupancy.ANY).limit(5L).collect(Collectors.toSet())).isEmpty()) {
            Optional pair = set.stream().findFirst();
            if (((ServerLevel)this.creature.level()).getPoiManager().exists((BlockPos)((Pair)pair.get()).getSecond(), p_217230_ -> true)) {
                this.blockPos = (BlockPos)((Pair)pair.get()).getSecond();
            }
            this.poiTypeResourceKey = (ResourceKey)((Holder)((Pair)pair.get()).getFirst()).unwrapKey().get();
            return true;
        }
        return false;
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        return this.poiTypeResourceKey != null;
    }

    public void start() {
        super.start();
        this.findBlock = false;
    }

    public void stop() {
        super.stop();
    }

    public double acceptedDistance() {
        return 8.0;
    }
}

