/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.entity.goal;

import baguchan.tofucraft.entity.Tofunian;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;

public class MakeFoodGoal
extends MoveToBlockGoal {
    private final Tofunian creature;
    private int cookTick;

    public MakeFoodGoal(Tofunian creature, double speedIn, int length) {
        super((PathfinderMob)creature, speedIn, length);
        this.creature = creature;
    }

    public boolean canUse() {
        return this.creature.getRole() == Tofunian.Roles.TOFUCOOK && !this.creature.hasExcessFood() && this.creature.hasFarmSeeds() && this.creature.level().isDay() && super.canUse();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.creature.getRole() == Tofunian.Roles.TOFUCOOK && !this.creature.hasExcessFood() && this.creature.hasFarmSeeds() && this.creature.level().isDay() && this.mob != null;
    }

    public void start() {
        super.start();
        this.cookTick = 0;
    }

    public void tick() {
        super.tick();
        this.creature.getLookControl().setLookAt(this.mob.getX(), this.mob.getY(), this.mob.getZ());
        if (this.cookTick > 0) {
            --this.cookTick;
        }
        if (this.isReachedTarget() && this.cookTick <= 0) {
            this.creature.cookingFood();
            this.creature.swing(InteractionHand.MAIN_HAND);
            this.creature.playSound(SoundEvents.ITEM_PICKUP, 1.0f, 0.7f);
            this.cookTick = 20;
        }
    }

    protected boolean isValidTarget(LevelReader worldIn, BlockPos pos) {
        BlockState blockstate = worldIn.getBlockState(pos);
        return this.creature.getRole().is(blockstate);
    }

    protected boolean findNearestBlock() {
        if (this.creature.getTofunianJobBlock() != null && this.isValidTarget((LevelReader)this.creature.level(), this.creature.getTofunianJobBlock())) {
            this.blockPos = this.creature.getTofunianJobBlock();
            return true;
        }
        return false;
    }

    public double acceptedDistance() {
        return 2.0;
    }
}

