/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.recipe;

import baguchan.tofucraft.recipe.TofuPotCategory;
import baguchan.tofucraft.recipe.TofuPotRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class TofuPotShapelessRecipe
implements TofuPotRecipe {
    final String group;
    final TofuPotCategory category;
    final ItemStack result;
    final NonNullList<Ingredient> ingredients;
    final Optional<SizedFluidIngredient> ingredientFluid;
    private final int cookTime;
    private final float experience;
    private final boolean isSimple;

    public TofuPotShapelessRecipe(String group, TofuPotCategory category, ItemStack result, NonNullList<Ingredient> ingredients, Optional<SizedFluidIngredient> ingredientFluid, int cookTime, float experience) {
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.ingredientFluid = ingredientFluid;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public RecipeSerializer<?> getSerializer() {
        return TofuRecipes.RECIPE_TOFU_POT_SHAPELESS.get();
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public TofuPotCategory category() {
        return this.category;
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public Optional<SizedFluidIngredient> fluidIngredient() {
        return this.ingredientFluid;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return this.result;
    }

    @Override
    public ItemStack getResult() {
        return this.result;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : input.items()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? ((Ingredient)this.ingredients.getFirst()).test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<TofuPotShapelessRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, Optional<SizedFluidIngredient>> OPTIONAL_STREAM_CODEC = ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC);
        private static final MapCodec<TofuPotShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)TofuPotCategory.CODEC.fieldOf("category").orElse((Object)TofuPotCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
            Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
            if (aingredient.length == 0) {
                return DataResult.error(() -> "No ingredients for shapeless recipe");
            }
            return aingredient.length > 12 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(12)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
        }, DataResult::success).forGetter(p_300975_ -> p_300975_.ingredients), (App)SizedFluidIngredient.NESTED_CODEC.optionalFieldOf("fluid").forGetter(potShapelessRecipe -> potShapelessRecipe.ingredientFluid), (App)Codec.INT.fieldOf("cook_time").orElse((Object)300).forGetter(potShapelessRecipe -> potShapelessRecipe.cookTime), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.1f)).forGetter(potShapelessRecipe -> Float.valueOf(potShapelessRecipe.experience))).apply((Applicative)p_340779_, (group1, category1, result1, ingredients1, fluidIngredient, cookTime, experience) -> new TofuPotShapelessRecipe((String)group1, (TofuPotCategory)((Object)((Object)category1)), (ItemStack)result1, (NonNullList<Ingredient>)ingredients1, (Optional<SizedFluidIngredient>)fluidIngredient, (int)cookTime, experience.floatValue())));
        public static final StreamCodec<RegistryFriendlyByteBuf, TofuPotShapelessRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<TofuPotShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TofuPotShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static TofuPotShapelessRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            String s = buffer.readUtf();
            TofuPotCategory craftingbookcategory = (TofuPotCategory)buffer.readEnum(TofuPotCategory.class);
            int i = buffer.readVarInt();
            NonNullList nonnulllist = NonNullList.withSize((int)i, (Object)Ingredient.EMPTY);
            nonnulllist.replaceAll(p_319735_ -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
            ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
            Optional fluidIngredient = (Optional)OPTIONAL_STREAM_CODEC.decode((Object)buffer);
            return new TofuPotShapelessRecipe(s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist, fluidIngredient, buffer.readInt(), buffer.readFloat());
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, TofuPotShapelessRecipe recipe) {
            buffer.writeUtf(recipe.group);
            buffer.writeEnum((Enum)recipe.category);
            buffer.writeVarInt(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
            }
            ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
            OPTIONAL_STREAM_CODEC.encode((Object)buffer, recipe.ingredientFluid);
            buffer.writeInt(recipe.cookTime);
            buffer.writeFloat(recipe.experience);
        }
    }
}

