/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.registry;

import baguchan.tofucraft.registry.TofuItems;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;

public class TofuTrimMaterials {
    public static final ResourceKey<TrimMaterial> TOFU_METAL = TofuTrimMaterials.registerKey("tofu_metal");
    public static final ResourceKey<TrimMaterial> TOFU_DIAMOND = TofuTrimMaterials.registerKey("tofu_diamond");
    public static final ResourceKey<TrimMaterial> ZUNDA_RUBY = TofuTrimMaterials.registerKey("zunda_ruby");

    private static ResourceKey<TrimMaterial> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.TRIM_MATERIAL, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)name));
    }

    public static void bootstrap(BootstrapContext<TrimMaterial> context) {
        TofuTrimMaterials.register(context, TOFU_METAL, (Item)TofuItems.TOFUMETAL.get(), Style.EMPTY.withColor(11188674), 0.2f);
        TofuTrimMaterials.register(context, TOFU_DIAMOND, (Item)TofuItems.TOFUDIAMOND.get(), Style.EMPTY.withColor(7126763), 0.8f);
        TofuTrimMaterials.register(context, ZUNDA_RUBY, (Item)TofuItems.ZUNDARUBY.get(), Style.EMPTY.withColor(3761421), 0.7f);
    }

    private static void register(BootstrapContext<TrimMaterial> context, ResourceKey<TrimMaterial> trimKey, Item trimItem, Style color, float itemModelIndex) {
        TrimMaterial material = TrimMaterial.create((String)trimKey.location().getPath(), (Item)trimItem, (float)itemModelIndex, (Component)Component.translatable((String)Util.makeDescriptionId((String)"trim_material", (ResourceLocation)trimKey.location())).withStyle(color), Map.of());
        context.register(trimKey, (Object)material);
    }
}

