/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.dimension.DimensionType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;

public class ClientUtils {
    @OnlyIn(value=Dist.CLIENT)
    public static void playPortalSound(Player localPlayer) {
        Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forLocalAmbience((SoundEvent)SoundEvents.PORTAL_TRIGGER, (float)(localPlayer.getRandom().nextFloat() * 0.4f + 0.8f), (float)0.25f));
    }

    public static void renderOverlay(Minecraft mc, PoseStack stack, IClientFluidTypeExtensions clientFluidTypeExtensions) {
        ResourceLocation texture = clientFluidTypeExtensions.getRenderOverlayTexture(mc);
        if (texture == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        BlockPos playerEyePos = BlockPos.containing((double)mc.player.getX(), (double)mc.player.getEyeY(), (double)mc.player.getZ());
        float brightness = LightTexture.getBrightness((DimensionType)mc.player.level().dimensionType(), (int)mc.player.level().getMaxLocalRawBrightness(playerEyePos));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)brightness, (float)brightness, (float)brightness, (float)0.85f);
        float uOffset = -mc.player.getYRot() / 64.0f;
        float vOffset = mc.player.getXRot() / 64.0f;
        Matrix4f pose = stack.last().pose();
        buffer.addVertex(pose, -1.0f, -1.0f, -0.5f).setUv(4.0f + uOffset, 4.0f + vOffset);
        buffer.addVertex(pose, 1.0f, -1.0f, -0.5f).setUv(uOffset, 4.0f + vOffset);
        buffer.addVertex(pose, 1.0f, 1.0f, -0.5f).setUv(uOffset, vOffset);
        buffer.addVertex(pose, -1.0f, 1.0f, -0.5f).setUv(4.0f + uOffset, vOffset);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderSystem.disableBlend();
    }
}

