/*
 * Decompiled with CFR 0.152.
 */
package baguchan.tofucraft.utils;

import baguchan.tofucraft.recipe.BitternRecipe;
import baguchan.tofucraft.recipe.HardenRecipe;
import baguchan.tofucraft.recipe.TFShapedRecipe;
import baguchan.tofucraft.registry.TofuRecipes;
import java.util.Iterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class RecipeHelper {
    public static <T> void placeRecipe(int width, int height, int outputSlot, RecipeHolder<?> recipe, Iterator<T> ingredients, int maxAmount, PlaceRecipe<T> placeRecipeMixin) {
        int i = width;
        int j = height;
        Recipe recipe2 = recipe.value();
        if (recipe2 instanceof TFShapedRecipe) {
            TFShapedRecipe shapedrecipe = (TFShapedRecipe)recipe2;
            i = shapedrecipe.getWidth();
            j = shapedrecipe.getHeight();
        }
        int k1 = 0;
        block0: for (int k = 0; k < height; ++k) {
            if (k1 == outputSlot) {
                ++k1;
            }
            boolean flag = (float)j < (float)height / 2.0f;
            int l = Mth.floor((float)((float)height / 2.0f - (float)j / 2.0f));
            if (flag && l > k) {
                k1 += width;
                ++k;
            }
            for (int i1 = 0; i1 < width; ++i1) {
                boolean flag1;
                if (!ingredients.hasNext()) {
                    return;
                }
                flag = (float)i < (float)width / 2.0f;
                l = Mth.floor((float)((float)width / 2.0f - (float)i / 2.0f));
                int j1 = i;
                boolean bl = flag1 = i1 < i;
                if (flag) {
                    j1 = l + i;
                    boolean bl2 = flag1 = l <= i1 && i1 < l + i;
                }
                if (flag1) {
                    placeRecipeMixin.addItemToSlot(ingredients.next(), k1, maxAmount, i1, k);
                } else if (j1 == i1) {
                    k1 += width - i1;
                    continue block0;
                }
                ++k1;
            }
        }
    }

    @Nullable
    public static ItemStack getTofu(ServerLevel serverLevel, Block block) {
        RecipeManager manager = serverLevel.getRecipeManager();
        if (block.asItem() != null) {
            Stream<RecipeHolder> tofuRecipe = manager.getRecipes().stream().filter(recipe -> {
                HardenRecipe hardenRecipe;
                Recipe patt0$temp = recipe.value();
                return patt0$temp instanceof HardenRecipe && (hardenRecipe = (HardenRecipe)patt0$temp).getType() == TofuRecipes.RECIPETYPE_HARDER.get();
            });
            for (RecipeHolder recipe2 : tofuRecipe.collect(Collectors.toList())) {
                HardenRecipe hardenRecipe;
                Recipe recipe3 = recipe2.value();
                if (!(recipe3 instanceof HardenRecipe) || !(hardenRecipe = (HardenRecipe)recipe3).getTofu().test(new ItemStack((ItemLike)block.asItem()))) continue;
                return ((HardenRecipe)recipe2.value()).getResultItem((HolderLookup.Provider)serverLevel.registryAccess());
            }
        }
        return null;
    }

    @Nullable
    public static ItemStack getBitternResult(ServerLevel serverLevel, Fluid fluid, FluidStack extraFluid) {
        RecipeManager manager = serverLevel.getRecipeManager();
        if (fluid != null) {
            Stream<RecipeHolder> tofuRecipe = manager.getRecipes().stream().filter(recipe -> {
                BitternRecipe bittern;
                Recipe patt0$temp = recipe.value();
                return patt0$temp instanceof BitternRecipe && (bittern = (BitternRecipe)patt0$temp).getType() == TofuRecipes.RECIPETYPE_BITTERN.get();
            });
            for (RecipeHolder recipe2 : tofuRecipe.collect(Collectors.toList())) {
                BitternRecipe bitternRecipe;
                Recipe recipe3 = recipe2.value();
                if (!(recipe3 instanceof BitternRecipe) || !(bitternRecipe = (BitternRecipe)recipe3).getFluid().is(fluid) || bitternRecipe.getExtraFluid().getFluid() != extraFluid.getFluid()) continue;
                return bitternRecipe.getResultItem((HolderLookup.Provider)serverLevel.registryAccess());
            }
        }
        return null;
    }

    public static RecipeManager getManager() {
        return RecipeHelper.getManager(null);
    }

    public static RecipeManager getManager(@Nullable RecipeManager manager) {
        if (manager != null) {
            return manager;
        }
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return Minecraft.getInstance().player.connection.getRecipeManager();
        }
        return ServerLifecycleHooks.getCurrentServer().getRecipeManager();
    }
}

