/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.attachment;

import baguchi.tofucraft.network.RecoverHealthPacket;
import baguchi.tofucraft.network.ZundafiedPacket;
import baguchi.tofucraft.utils.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.UnknownNullability;

public class TofuLivingAttachment
implements INBTSerializable<CompoundTag> {
    public boolean isInsidePortal = false;
    public int portalTimer = 0;
    public float portalAnimTime = 0.0f;
    public float prevPortalAnimTime = 0.0f;
    public float recoverHealth = 0.0f;
    public int wolfEatCooldown;
    public boolean zundafied = false;

    public void tick(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            this.handlePortal(player);
        }
        this.handleFood(entity);
    }

    private void handleFood(Entity entity) {
        if (this.wolfEatCooldown > 0) {
            --this.wolfEatCooldown;
        }
    }

    public boolean isWolfEatCooldown() {
        return this.wolfEatCooldown > 0;
    }

    public void setRecoverHealth(Entity entity, float recoverHealth) {
        this.recoverHealth = recoverHealth;
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new RecoverHealthPacket(living, recoverHealth), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public float getRecoverHealth() {
        return this.recoverHealth;
    }

    public void setZundafied(Entity entity, boolean zundafied) {
        this.zundafied = zundafied;
        if (!entity.level().isClientSide() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new ZundafiedPacket(living, zundafied), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean isZundafied() {
        return this.zundafied;
    }

    public void setInPortal(boolean inPortal) {
        this.isInsidePortal = inPortal;
    }

    public boolean isInsidePortal() {
        return this.isInsidePortal;
    }

    public void setPortalTimer(int timer) {
        this.portalTimer = timer;
    }

    public int getPortalTimer() {
        return this.portalTimer;
    }

    public float getPortalAnimTime() {
        return this.portalAnimTime;
    }

    public float getPrevPortalAnimTime() {
        return this.prevPortalAnimTime;
    }

    public void handlePortal(Player player) {
        if (player.level().isClientSide()) {
            this.prevPortalAnimTime = this.portalAnimTime;
            if (this.isInsidePortal()) {
                if (!(Minecraft.getInstance().screen == null || Minecraft.getInstance().screen.isPauseScreen() || Minecraft.getInstance().screen instanceof DeathScreen || Minecraft.getInstance().screen instanceof WinScreen)) {
                    if (Minecraft.getInstance().screen instanceof AbstractContainerScreen) {
                        player.closeContainer();
                    }
                    Minecraft.getInstance().setScreen(null);
                }
                if (this.portalAnimTime == 0.0f) {
                    ClientUtils.playPortalSound(player);
                }
            }
        }
        if (this.isInsidePortal()) {
            ++this.portalTimer;
            if (player.level().isClientSide()) {
                this.portalAnimTime += 0.0125f;
                if (this.getPortalAnimTime() > 1.0f) {
                    this.portalAnimTime = 1.0f;
                }
            }
            this.isInsidePortal = false;
        } else {
            if (player.level().isClientSide()) {
                if (this.getPortalAnimTime() > 0.0f) {
                    this.portalAnimTime -= 0.05f;
                }
                if (this.getPortalAnimTime() < 0.0f) {
                    this.portalAnimTime = 0.0f;
                }
            }
            if (this.getPortalTimer() > 0) {
                this.portalTimer -= 4;
            }
        }
    }

    public void setWolfEatCooldown(int wolfEatCooldown) {
        this.wolfEatCooldown = wolfEatCooldown;
    }

    public @UnknownNullability CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        nbt.putFloat("recover_health", this.recoverHealth);
        nbt.putBoolean("zundafied", this.zundafied);
        if (this.wolfEatCooldown > 0) {
            nbt.putInt("wolf_eat_cooldown", this.wolfEatCooldown);
        }
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.recoverHealth = nbt.getFloatOr("recover_health", 0.0f);
        this.zundafied = nbt.getBooleanOr("zundafied", false);
        if (nbt.contains("wolf_eat_cooldown")) {
            this.wolfEatCooldown = nbt.getIntOr("wolf_eat_cooldown", 0);
        }
    }
}

