/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block;

import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.utils.RecipeHelper;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TofuBlock
extends Block {
    public static final IntegerProperty HARDNESS = IntegerProperty.create((String)"hardness", (int)0, (int)7);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public TofuBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos)) {
            float f;
            if (rand.nextInt(5) == 0) {
                double d4 = rand.nextBoolean() ? 0.8 : -0.8;
                double d0 = (double)pos.getX() + 0.5 + (double)rand.nextFloat() * d4;
                double d1 = (float)pos.getY() + rand.nextFloat();
                double d2 = (double)pos.getZ() + 0.5 + (double)rand.nextFloat() * d4;
                SimpleParticleType particle = rand.nextInt(3) == 0 ? (ParticleOptions)TofuParticleTypes.DRIP_SOYMILK_HANG.get() : ParticleTypes.DRIPPING_WATER;
                worldIn.addParticle((ParticleOptions)particle, d0, d1, d2, 0.0, 0.0, 0.0);
            }
            if (this.isMoreHardenCondition(worldIn, pos) && !((f = rand.nextFloat()) > 0.15f)) {
                TofuBlock.spawnDripParticle(worldIn, pos.below(2), stateIn);
            }
        }
    }

    private static void spawnDripParticle(Level p_154072_, BlockPos p_154073_, BlockState p_154074_) {
        Vec3 vec3 = p_154074_.getOffset(p_154073_);
        double d0 = 0.0625;
        double d1 = (double)p_154073_.getX() + 0.5 + vec3.x;
        double d2 = (double)((float)(p_154073_.getY() + 1) - 0.6875f) - 0.0625;
        double d3 = (double)p_154073_.getZ() + 0.5 + vec3.z;
        SimpleParticleType particleoptions = ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        p_154072_.addParticle((ParticleOptions)particleoptions, d1, d2, d3, 0.0, 0.0, 0.0);
    }

    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        super.randomTick(state, worldIn, pos, random);
        if (this.isDriedCondition((Level)worldIn, pos)) {
            if (random.nextInt(8) == 0 && this == TofuBlocks.MOMENTOFU.get()) {
                worldIn.setBlock(pos, ((Block)TofuBlocks.DRIEDTOFU.get()).defaultBlockState(), 2);
            }
        } else if (this.isUnderWeight((Level)worldIn, pos) && state.hasProperty((Property)HARDNESS)) {
            int hardness;
            boolean dripStoneFlag = this.isMoreHardenCondition((Level)worldIn, pos);
            int i = (Integer)state.getValue((Property)HARDNESS);
            int hardenSpeed = dripStoneFlag ? 1 : 0;
            int n = hardness = this == TofuBlocks.MOMENTOFU.get() ? 2 - hardenSpeed : 3 - hardenSpeed;
            if (random.nextInt(hardness) == 0) {
                if (i < 7) {
                    worldIn.setBlock(pos, (BlockState)state.setValue((Property)HARDNESS, (Comparable)Integer.valueOf(i + 1)), 2);
                } else {
                    ItemStack result = RecipeHelper.getTofu(worldIn, state.getBlock());
                    if (result != null) {
                        worldIn.setBlock(pos, Block.byItem((Item)result.getItem()).defaultBlockState(), 2);
                    }
                }
            }
        }
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor p_202007_, BlockPos p_202008_, Direction.AxisDirection p_202009_, BiPredicate<BlockPos, BlockState> p_202010_, Predicate<BlockState> p_202011_, int p_202012_) {
        Direction direction = Direction.get((Direction.AxisDirection)p_202009_, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = p_202008_.mutable();
        for (int i = 1; i < p_202012_; ++i) {
            blockpos$mutableblockpos.move(direction);
            BlockState blockstate = p_202007_.getBlockState((BlockPos)blockpos$mutableblockpos);
            if (p_202011_.test(blockstate)) {
                return Optional.of(blockpos$mutableblockpos.immutable());
            }
            if (!p_202007_.isOutsideBuildHeight(blockpos$mutableblockpos.getY()) && p_202010_.test((BlockPos)blockpos$mutableblockpos, blockstate)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    public boolean isMoreHardenCondition(Level world, BlockPos pos) {
        BlockState dripstoneBlock = world.getBlockState(pos.below(2));
        return dripstoneBlock.is(Blocks.POINTED_DRIPSTONE) && dripstoneBlock.getValue((Property)PointedDripstoneBlock.TIP_DIRECTION) == Direction.DOWN;
    }

    public boolean isUnderWeight(Level world, BlockPos pos) {
        BlockState weightBlock = world.getBlockState(pos.above());
        BlockState baseBlock = world.getBlockState(pos.below());
        float weightHardness = weightBlock.getDestroySpeed((BlockGetter)world, pos.above());
        boolean isWeightValid = weightBlock.isFaceSturdy((BlockGetter)world, pos, Direction.DOWN) && (weightHardness >= 1.0f || weightHardness < 0.0f) && !(weightBlock.getBlock() instanceof TofuBlock);
        float baseHardness = baseBlock.getDestroySpeed((BlockGetter)world, pos.below());
        boolean isBaseValid = baseBlock.isFaceSturdy((BlockGetter)world, pos, Direction.UP) && (baseHardness >= 1.0f || baseHardness < 0.0f) && !(baseBlock.getBlock() instanceof TofuBlock);
        return isWeightValid && isBaseValid;
    }

    public boolean isDriedCondition(Level world, BlockPos pos) {
        BlockState upperBlock = world.getBlockState(pos.above(1));
        return ((Biome)world.getBiome(pos).value()).getBaseTemperature() < 0.15f && !world.canSeeSky(pos.above()) && upperBlock.isAir();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_49915_) {
        p_49915_.add(new Property[]{HARDNESS});
    }
}

