/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block.tfenergy;

import baguchi.tofucraft.block.tfenergy.TFBaseEntityBlock;
import baguchi.tofucraft.blockentity.tfenergy.TFStorageBlockEntity;
import baguchi.tofucraft.client.ClientProxy;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.wrappers.FluidBucketWrapper;

public class TFStorageBlock
extends TFBaseEntityBlock {
    public static final MapCodec<TFStorageBlock> CODEC = TFStorageBlock.simpleCodec(TFStorageBlock::new);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    private static final VoxelShape TIP = Block.box((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)11.0, (double)16.0);
    private static final VoxelShape AABB = Shapes.or((VoxelShape)TIP, (VoxelShape)BASE);

    public TFStorageBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected VoxelShape getShape(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return AABB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext p_48689_) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)p_48689_.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState p_48722_, Rotation p_48723_) {
        return (BlockState)p_48722_.setValue(FACING, (Comparable)p_48723_.rotate((Direction)p_48722_.getValue(FACING)));
    }

    public BlockState mirror(BlockState p_48719_, Mirror p_48720_) {
        return p_48719_.rotate(p_48720_.getRotation((Direction)p_48719_.getValue(FACING)));
    }

    protected InteractionResult useItemOn(ItemStack p_316304_, BlockState p_48706_, Level p_48707_, BlockPos p_48708_, Player p_48709_, InteractionHand p_48710_, BlockHitResult p_48711_) {
        IFluidHandlerItem handler;
        boolean flag = false;
        ItemStack stack = p_48709_.getItemInHand(p_48710_);
        BlockEntity blockentity = p_48707_.getBlockEntity(p_48708_);
        if (blockentity instanceof TFStorageBlockEntity && (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)stack.copyWithCount(1)).orElse(null)) != null && handler instanceof FluidBucketWrapper) {
            FluidUtil.interactWithFluidHandler((Player)p_48709_, (InteractionHand)p_48710_, (Level)p_48707_, (BlockPos)p_48708_, null);
            flag = true;
        }
        if (!flag) {
            if (p_48707_.isClientSide) {
                ClientProxy.PROXY.setRefrencedTE(p_48707_.getBlockEntity(p_48708_));
                return InteractionResult.SUCCESS;
            }
            this.openContainer(p_48707_, p_48708_, p_48709_);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void openContainer(Level p_53631_, BlockPos p_53632_, Player p_53633_) {
        BlockEntity blockentity = p_53631_.getBlockEntity(p_53632_);
        if (blockentity instanceof TFStorageBlockEntity) {
            p_53633_.openMenu((MenuProvider)blockentity);
        }
    }

    protected void affectNeighborsAfterRemoval(BlockState p_394424_, ServerLevel p_394241_, BlockPos p_393520_, boolean p_394545_) {
        super.affectNeighborsAfterRemoval(p_394424_, p_394241_, p_393520_, p_394545_);
        BlockEntity blockentity = p_394241_.getBlockEntity(p_393520_);
        if (blockentity instanceof TFStorageBlockEntity) {
            if (p_394241_ instanceof ServerLevel) {
                Containers.dropContents((Level)p_394241_, (BlockPos)p_393520_, (Container)((TFStorageBlockEntity)blockentity));
            }
            p_394241_.updateNeighbourForOutputSignal(p_393520_, (Block)this);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState p_48700_) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState p_48702_, Level p_48703_, BlockPos p_48704_) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)p_48703_.getBlockEntity(p_48704_));
    }

    public RenderShape getRenderShape(BlockState p_48727_) {
        return RenderShape.MODEL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_48725_) {
        p_48725_.add(new Property[]{FACING, LIT});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos p_153215_, BlockState p_153216_) {
        return new TFStorageBlockEntity(p_153215_, p_153216_);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_152382_, BlockState p_152383_, BlockEntityType<T> p_152384_) {
        return TFStorageBlock.createTicker(p_152382_, p_152384_, (BlockEntityType<? extends TFStorageBlockEntity>)((BlockEntityType)TofuBlockEntitys.TF_STORAGE.get()));
    }

    @Nullable
    protected static <T extends BlockEntity> BlockEntityTicker<T> createTicker(Level p_151988_, BlockEntityType<T> p_151989_, BlockEntityType<? extends TFStorageBlockEntity> p_151990_) {
        return TFStorageBlock.createTickerHelper(p_151989_, p_151990_, TFStorageBlockEntity::tick);
    }
}

