/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.block.utils;

import baguchi.tofucraft.block.utils.WeightBaseBlock;
import baguchi.tofucraft.registry.TofuParticleTypes;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MisoBarrelBlock
extends WeightBaseBlock {
    public final Supplier<Item> finishedBottleItem;
    public static final IntegerProperty FLUIDS = IntegerProperty.create((String)"fluids", (int)0, (int)6);

    public MisoBarrelBlock(Supplier<Item> finishedBottleItem, BlockBehaviour.Properties properties) {
        super(properties);
        this.finishedBottleItem = finishedBottleItem;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)STAT, (Comparable)((Object)WeightBaseBlock.Stat.USING))).setValue((Property)TIME, (Comparable)Integer.valueOf(0))).setValue((Property)FLUIDS, (Comparable)Integer.valueOf(0)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        super.animateTick(stateIn, worldIn, pos, rand);
        if (this.isUnderWeight(worldIn, pos) && rand.nextInt(3) == 0) {
            double d4 = rand.nextBoolean() ? 0.8 : -0.8;
            double d0 = (double)pos.getX() + 0.5 + (double)rand.nextFloat() * d4;
            double d1 = (float)pos.getY() + rand.nextFloat();
            double d2 = (double)pos.getZ() + 0.5 + (double)rand.nextFloat() * d4;
            ParticleOptions particle = (ParticleOptions)TofuParticleTypes.DRIP_SOYSAUCE_HANG.get();
            worldIn.addParticle(particle, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void randomTick(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        WeightBaseBlock.Stat stat = this.getStat(state);
        int time = (Integer)state.getValue((Property)TIME);
        if (this.isUnderWeight((Level)worldIn, pos)) {
            if (time < 5 && random.nextInt(4) == 0) {
                worldIn.setBlock(pos, (BlockState)state.setValue((Property)TIME, (Comparable)Integer.valueOf(time + 1)), 3);
            }
            if (time >= 5 && stat == WeightBaseBlock.Stat.USING) {
                worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)STAT, (Comparable)((Object)WeightBaseBlock.Stat.USED))).setValue((Property)FLUIDS, (Comparable)Integer.valueOf(6)), 3);
            }
        }
    }

    protected InteractionResult useItemOn(ItemStack itemHeld, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult p_316140_) {
        WeightBaseBlock.Stat stat = this.getStat(state);
        int fluidsAmounts = (Integer)state.getValue((Property)FLUIDS);
        if (stat == WeightBaseBlock.Stat.USED && fluidsAmounts > 0 && itemHeld != null && itemHeld.getItem() == Items.GLASS_BOTTLE) {
            ItemStack nigari = new ItemStack((ItemLike)this.finishedBottleItem.get());
            worldIn.playSound(null, pos, SoundEvents.BOTTLE_FILL, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (itemHeld.getCount() == 1) {
                player.setItemInHand(handIn, nigari);
            } else {
                if (!player.getInventory().add(nigari)) {
                    worldIn.addFreshEntity((Entity)new ItemEntity(worldIn, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, nigari));
                }
                itemHeld.shrink(1);
            }
            worldIn.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)STAT, (Comparable)((Object)WeightBaseBlock.Stat.USED))).setValue((Property)FLUIDS, (Comparable)Integer.valueOf(fluidsAmounts - 1)), 3);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STAT, TIME, FLUIDS});
    }
}

