/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity.tfenergy;

import baguchi.tofucraft.block.tfenergy.TFCraftingTableBlock;
import baguchi.tofucraft.blockentity.tfenergy.base.WorkerBaseBlockEntity;
import baguchi.tofucraft.inventory.TFCraftingTableMenu;
import baguchi.tofucraft.recipe.TFCraftingRecipe;
import baguchi.tofucraft.registry.TofuBlockEntitys;
import baguchi.tofucraft.registry.TofuRecipes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.RecipeCraftingHolder;
import net.minecraft.world.inventory.StackedContentsCompatible;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.UseRemainder;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class TFCraftingTableBlockEntity
extends WorkerBaseBlockEntity
implements WorldlyContainer,
StackedContentsCompatible,
RecipeCraftingHolder,
MenuProvider {
    protected NonNullList<ItemStack> inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
    private int progress = 0;
    private int progressMax = 0;
    private int refreshTime = 0;
    public static final int MAX_CRAFT_TIME = 200;
    private final RecipeManager.CachedCheck<CraftingInput, ? extends TFCraftingRecipe> quickCheck;
    private static final int[] SLOTS_FOR_UP = new int[]{0};
    private static final int[] SLOTS_FOR_DOWN = new int[]{1};
    protected final ContainerData dataAccess = new ContainerData(){

        public int get(int p_221476_1_) {
            switch (p_221476_1_) {
                case 0: {
                    return TFCraftingTableBlockEntity.this.progress;
                }
                case 1: {
                    return TFCraftingTableBlockEntity.this.progressMax;
                }
                case 2: {
                    return TFCraftingTableBlockEntity.this.energy;
                }
                case 3: {
                    return TFCraftingTableBlockEntity.this.energyMax;
                }
            }
            return 0;
        }

        public void set(int p_221477_1_, int p_221477_2_) {
            switch (p_221477_1_) {
                case 0: {
                    TFCraftingTableBlockEntity.this.progress = p_221477_2_;
                    break;
                }
                case 1: {
                    TFCraftingTableBlockEntity.this.progressMax = p_221477_2_;
                    break;
                }
                case 2: {
                    TFCraftingTableBlockEntity.this.energy = p_221477_2_;
                    break;
                }
                case 3: {
                    TFCraftingTableBlockEntity.this.energyMax = p_221477_2_;
                }
            }
        }

        public int getCount() {
            return 4;
        }
    };

    public TFCraftingTableBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)TofuBlockEntitys.TF_CRAFTING_TABLE.get(), p_155229_, p_155230_, 10000);
        this.quickCheck = RecipeManager.createCheck(TofuRecipes.RECIPETYPE_TF_CRAFT.get());
    }

    public static void tick(Level level, BlockPos blockPos, BlockState blockState, TFCraftingTableBlockEntity tfoven) {
        if (level.isClientSide()) {
            return;
        }
        boolean worked = false;
        if (tfoven.getEnergyStored() > 0 && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (tfoven.refreshTime <= 0) {
                Optional optional = tfoven.quickCheck.getRecipeFor((RecipeInput)CraftingInput.of((int)3, (int)3, tfoven.inventory), serverLevel);
                if (optional.isPresent()) {
                    tfoven.progressMax = ((TFCraftingRecipe)((RecipeHolder)optional.get()).value()).getNeedTF() / 10;
                    ++tfoven.progress;
                    if (tfoven.progress >= tfoven.progressMax) {
                        tfoven.progress = 0;
                        if (tfoven.burn(level.registryAccess(), (RecipeHolder<? extends TFCraftingRecipe>)((RecipeHolder)optional.get()), tfoven.inventory)) {
                            tfoven.setRecipeUsed((RecipeHolder)optional.get());
                        }
                    }
                    worked = true;
                    tfoven.drain(10, false);
                } else {
                    tfoven.refreshTime = 30 + tfoven.level.random.nextInt(30);
                }
            } else {
                tfoven.progress = 0;
                --tfoven.refreshTime;
            }
        }
        if ((Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != worked) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)BlockStateProperties.LIT, (Comparable)Boolean.valueOf(worked)), 2);
        }
        if (worked) {
            tfoven.setChanged();
        }
    }

    private boolean burn(RegistryAccess p_266740_, @javax.annotation.Nullable RecipeHolder<? extends TFCraftingRecipe> p_300910_, NonNullList<ItemStack> p_267073_) {
        if (p_300910_ != null) {
            ItemStack itemstack1 = ((TFCraftingRecipe)p_300910_.value()).assemble((RecipeInput)CraftingInput.of((int)3, (int)3, p_267073_), (HolderLookup.Provider)p_266740_);
            ItemStack itemstack2 = (ItemStack)p_267073_.get(9);
            if (itemstack2.isEmpty()) {
                p_267073_.set(9, (Object)itemstack1.copy());
            } else if (itemstack2.is(itemstack1.getItem())) {
                itemstack2.grow(itemstack1.getCount());
            }
            for (int i = 0; i < 9; ++i) {
                ItemStack slotStack = (ItemStack)this.inventory.get(i);
                if (slotStack.has(DataComponents.USE_REMAINDER)) {
                    this.ejectIngredientRemainder(((UseRemainder)slotStack.get(DataComponents.USE_REMAINDER)).convertInto());
                }
                if (slotStack.isEmpty()) continue;
                slotStack.shrink(1);
            }
            return true;
        }
        return false;
    }

    protected void ejectIngredientRemainder(ItemStack remainderStack) {
        Direction direction = ((Direction)this.getBlockState().getValue(TFCraftingTableBlock.HORIZONTAL_FACING)).getCounterClockWise();
        double x = (double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.25;
        double y = (double)this.worldPosition.getY() + 0.7;
        double z = (double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.25;
        ItemEntity entity = new ItemEntity(this.level, x, y, z, remainderStack);
        entity.setDeltaMovement((double)((float)direction.getStepX() * 0.08f), 0.25, (double)((float)direction.getStepZ() * 0.08f));
        this.level.addFreshEntity((Entity)entity);
    }

    public int getContainerSize() {
        return 10;
    }

    public ItemStack getItem(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.inventory) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack removeItemNoUpdate(int p_70304_1_) {
        return ContainerHelper.takeItem(this.inventory, (int)p_70304_1_);
    }

    public void setItem(int index, ItemStack stack) {
        this.inventory.set(index, (Object)stack);
        if (stack.getCount() > this.getMaxStackSize()) {
            stack.setCount(this.getMaxStackSize());
        }
        this.setChanged();
    }

    public ItemStack removeItem(int p_59613_, int p_59614_) {
        ItemStack itemstack = ContainerHelper.removeItem(this.inventory, (int)p_59613_, (int)p_59614_);
        if (!itemstack.isEmpty()) {
            this.setChanged();
        }
        return itemstack;
    }

    public boolean stillValid(Player p_18946_) {
        if (this.level.getBlockEntity(this.worldPosition) != this) {
            return false;
        }
        return p_18946_.distanceToSqr((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5) <= 64.0;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    @Override
    public void saveAdditional(CompoundTag cmp, HolderLookup.Provider p_338445_) {
        super.saveAdditional(cmp, p_338445_);
        ContainerHelper.saveAllItems((CompoundTag)cmp, this.inventory, (HolderLookup.Provider)p_338445_);
        cmp.putInt("progress", this.progress);
        cmp.putInt("progress_max", this.progressMax);
        cmp.putInt("RefreshTime", this.refreshTime);
    }

    @Override
    public void loadAdditional(CompoundTag cmp, HolderLookup.Provider p_338445_) {
        super.loadAdditional(cmp, p_338445_);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)cmp, this.inventory, (HolderLookup.Provider)p_338445_);
        this.progress = cmp.getIntOr("progress", 0);
        this.progressMax = cmp.getIntOr("progress_max", 0);
        this.refreshTime = cmp.getIntOr("RefreshTime", 0);
    }

    public int[] getSlotsForFace(Direction p_58363_) {
        if (p_58363_ == Direction.DOWN) {
            return SLOTS_FOR_DOWN;
        }
        return SLOTS_FOR_UP;
    }

    public boolean canPlaceItemThroughFace(int p_58336_, ItemStack p_58337_, @javax.annotation.Nullable Direction p_58338_) {
        return this.canPlaceItem(p_58336_, p_58337_);
    }

    public boolean canTakeItemThroughFace(int p_58392_, ItemStack p_58393_, Direction p_58394_) {
        return p_58392_ == 1;
    }

    public boolean canPlaceItem(int p_58389_, ItemStack p_58390_) {
        return p_58389_ != 1;
    }

    public void clearContent() {
        this.inventory.clear();
    }

    public void setRecipeUsed(@javax.annotation.Nullable RecipeHolder<?> p_301245_) {
    }

    @javax.annotation.Nullable
    public RecipeHolder<?> getRecipeUsed() {
        return null;
    }

    public void awardUsedRecipes(Player p_58396_, List<ItemStack> p_282202_) {
    }

    @Override
    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
        super.applyImplicitComponents(p_397929_);
        ((ItemContainerContents)p_397929_.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY)).copyInto(this.getInventory());
    }

    @Override
    protected void collectImplicitComponents(DataComponentMap.Builder p_338252_) {
        super.collectImplicitComponents(p_338252_);
        p_338252_.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.getInventory()));
    }

    @Override
    public void removeComponentsFromTag(CompoundTag p_331127_) {
        super.removeComponentsFromTag(p_331127_);
        p_331127_.remove("Items");
        p_331127_.remove("progress");
        p_331127_.remove("progress_max");
        p_331127_.remove("RefreshTime");
        p_331127_.remove("RecipesUsed");
    }

    public Component getDisplayName() {
        return Component.translatable((String)"container.tofucraft.tf_crafting_table.name");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int p_39954_, Inventory p_39955_, Player p_39956_) {
        return new TFCraftingTableMenu(p_39954_, p_39955_, this, this.dataAccess);
    }

    public void fillStackedContents(StackedItemContents stackedItemContents) {
        for (ItemStack itemstack : this.inventory) {
            stackedItemContents.accountSimpleStack(itemstack);
        }
    }
}

