/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.blockentity.tfenergy.base;

import baguchi.tofucraft.api.tfenergy.ITofuEnergy;
import baguchi.tofucraft.api.tfenergy.TFEnergyData;
import baguchi.tofucraft.api.tfenergy.TofuNetwork;
import baguchi.tofucraft.registry.TofuDataComponents;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class EnergyBaseBlockEntity
extends BlockEntity
implements ITofuEnergy {
    public static final String TAG_ENERGY = "tf_energy";
    public static final String TAG_ENERGY_MAX = "tf_energy_max";
    public static final String TAG_UUID = "tf_uuid";
    protected String uuid = "";
    protected int energy;
    protected int energyMax;

    public EnergyBaseBlockEntity(BlockEntityType<?> p_155228_, BlockPos p_155229_, BlockState p_155230_, int energyMax) {
        super(p_155228_, p_155229_, p_155230_);
        this.energyMax = energyMax;
    }

    @Override
    public int getEnergyStored() {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyMax;
    }

    @Override
    public int receive(int toReceive, boolean simulate) {
        if (this.getEnergyStored() > this.getMaxEnergyStored()) {
            return 0;
        }
        int calculated = Math.min(toReceive, this.getMaxEnergyStored() - this.getEnergyStored());
        if (!simulate) {
            this.energy += calculated;
        }
        return calculated;
    }

    @Override
    public int drain(int toDrain, boolean simulate) {
        int calculated = Math.min(toDrain, this.getEnergyStored());
        if (!simulate) {
            this.energy -= calculated;
        }
        return calculated;
    }

    @Override
    public boolean canReceive(BlockEntity from) {
        if (!(from instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    @Override
    public boolean canDrain(BlockEntity to) {
        if (!(to instanceof ITofuEnergy)) {
            throw new IllegalArgumentException("It must be a instance of ITofuEnergy!");
        }
        return true;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider p_338445_) {
        super.saveAdditional(compound, p_338445_);
        compound.putInt(TAG_ENERGY, this.energy);
        compound.putString(TAG_UUID, this.uuid);
        compound.putInt(TAG_ENERGY_MAX, this.energyMax);
    }

    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider p_338445_) {
        super.loadAdditional(compound, p_338445_);
        this.energyMax = compound.getIntOr(TAG_ENERGY_MAX, this.getMaxEnergyStored());
        this.energy = compound.getIntOr(TAG_ENERGY, 0);
        this.uuid = compound.getStringOr(TAG_UUID, "");
    }

    protected void applyImplicitComponents(DataComponentGetter p_397929_) {
        super.applyImplicitComponents(p_397929_);
        TFEnergyData tfEnergyData = (TFEnergyData)p_397929_.getOrDefault(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(this.energy, this.energyMax));
        this.energy = tfEnergyData.storeTF();
        this.energyMax = tfEnergyData.maxTF();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder p_338540_) {
        super.collectImplicitComponents(p_338540_);
        p_338540_.set(TofuDataComponents.TF_ENERGY_DATA, (Object)new TFEnergyData(this.energy, this.energyMax));
    }

    public void removeComponentsFromTag(CompoundTag p_331127_) {
        super.removeComponentsFromTag(p_331127_);
        p_331127_.remove(TAG_UUID);
        p_331127_.remove(TAG_ENERGY);
        p_331127_.remove(TAG_ENERGY_MAX);
    }

    public void onLoad() {
        super.onLoad();
        if (!this.getLevel().isClientSide()) {
            if (this.uuid.isEmpty()) {
                this.uuid = UUID.randomUUID().toString();
            }
            TofuNetwork.Instance.register(this.uuid, this, false);
        }
    }

    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        if (!this.getLevel().isClientSide()) {
            TofuNetwork.Instance.unload(this.uuid, false);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
        this.loadAdditional(pkt.getTag(), lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider p_323910_) {
        return this.saveWithoutMetadata(p_323910_);
    }

    protected void inventoryChanged() {
        super.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }
}

