/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.model;

import baguchi.tofucraft.client.animation.definitions.TofuGandlemAnimation;
import baguchi.tofucraft.client.render.state.TofuGandlemRenderState;
import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class TofuGandlemModel<T extends TofuGandlemRenderState>
extends EntityModel<T> {
    private final ModelPart baseRoot;
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart core;
    private final ModelPart core2;
    private final List<ModelPart> coreModelParts;

    public TofuGandlemModel(ModelPart root) {
        super(root);
        this.baseRoot = root;
        this.root = root.getChild("root");
        this.head = this.root.getChild("head");
        this.core = this.root.getChild("core");
        this.core2 = this.root.getChild("core2");
        this.coreModelParts = ImmutableList.of((Object)this.core, (Object)this.core2);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -3.0f, 10.0f, 15.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition head = root.addOrReplaceChild("head", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition core = root.addOrReplaceChild("core", CubeListBuilder.create().texOffs(32, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)7.0f, (float)0.0f));
        PartDefinition core2 = root.addOrReplaceChild("core2", CubeListBuilder.create().texOffs(32, 16).addBox(-2.0f, -2.0f, -2.0f, 4.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-3.0f));
        PartDefinition right_hand = root.addOrReplaceChild("right_hand", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition right_hand2 = right_hand.addOrReplaceChild("right_hand2", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition left_hand = root.addOrReplaceChild("left_hand", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)-4.0f, (float)0.0f));
        PartDefinition left_hand2 = left_hand.addOrReplaceChild("left_hand2", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, -1.0f, -3.0f, 3.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)7.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(T entity) {
        super.setupAnim(entity);
        if (((TofuGandlemRenderState)((Object)entity)).sleep) {
            this.head.xRot = 0.4f;
            this.head.yRot = 0.0f;
        } else {
            this.head.xRot = ((TofuGandlemRenderState)((Object)entity)).xRot * ((float)Math.PI / 180);
            this.head.yRot = ((TofuGandlemRenderState)((Object)entity)).yRot * ((float)Math.PI / 180);
        }
        this.animate(((TofuGandlemRenderState)((Object)entity)).attackAnimationState, TofuGandlemAnimation.ATTACK, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).shootAnimationState, TofuGandlemAnimation.SHOOT, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).shootingAnimationState, TofuGandlemAnimation.SHOOTING, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).rushAnimationState, TofuGandlemAnimation.RUSH, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).idleAnimationState, TofuGandlemAnimation.IDLE, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).deathAnimationState, TofuGandlemAnimation.DEATH, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).chargeAnimationState, TofuGandlemAnimation.CHARGE, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).chargeStopAnimationState, TofuGandlemAnimation.CHARGE_STOP, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
        this.animate(((TofuGandlemRenderState)((Object)entity)).chargeFailAnimationState, TofuGandlemAnimation.CHARGE_FAIL, ((TofuGandlemRenderState)((Object)entity)).ageInTicks);
    }

    public List<ModelPart> getCoreModelParts() {
        return this.coreModelParts;
    }
}

