/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleZundaCloud
extends TextureSheetParticle {
    private final float scale;
    private final float shake;

    public ParticleZundaCloud(ClientLevel level, double x, double y, double z, double vx, double vy, double vz, double scale, int duration, double shake) {
        super(level, x, y, z);
        this.scale = (float)scale * 0.4f * 0.1f;
        this.lifetime = duration;
        this.xd = vx * 0.8;
        this.yd = vy * 0.8;
        this.zd = vz * 0.8;
        this.roll = this.oRoll = (float)((double)this.random.nextInt(4) * Math.PI / 2.0);
        this.shake = (float)shake;
    }

    public void render(VertexConsumer consumer, Camera camera, float tick) {
        float time = ((float)this.age + tick) / (float)this.lifetime;
        this.alpha = Mth.clamp((float)(1.0f - time), (float)0.1f, (float)1.0f);
        this.quadSize = this.scale * (0.7f * time + 0.3f);
        super.render(consumer, camera, tick);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public void tick() {
        super.tick();
        this.xd *= (double)this.shake;
        this.yd *= (double)this.shake;
        this.zd *= (double)this.shake;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static final class CloudFactory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprite;

        public CloudFactory(SpriteSet sprite) {
            this.sprite = sprite;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            ParticleZundaCloud particleCloud = new ParticleZundaCloud(level, x, y, z, xSpeed, ySpeed, zSpeed, 3.0, 20, 1.1f);
            particleCloud.setSpriteFromAge(this.sprite);
            return particleCloud;
        }
    }
}

