/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.render.blockentity;

import baguchi.tofucraft.block.FoodPlateBlock;
import baguchi.tofucraft.blockentity.FoodPlateBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class FoodPlateRender
implements BlockEntityRenderer<FoodPlateBlockEntity> {
    private final RandomSource random = RandomSource.create();

    public FoodPlateRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(FoodPlateBlockEntity plateBlockEntity, float p_112308_, PoseStack poseStack, MultiBufferSource p_112310_, int p_112311_, int p_112312_, Vec3 vec3) {
        Direction direction = ((Direction)plateBlockEntity.getBlockState().getValue(FoodPlateBlock.FACING)).getOpposite();
        ItemStack boardStack = plateBlockEntity.getStoredItem();
        int posLong = (int)plateBlockEntity.getBlockPos().asLong();
        int j = this.getRenderAmount(boardStack);
        int i = boardStack.isEmpty() ? 187 : Item.getId((Item)boardStack.getItem()) + boardStack.getDamageValue();
        this.random.setSeed((long)i);
        if (!boardStack.isEmpty()) {
            for (int k = 0; k < j; ++k) {
                poseStack.pushPose();
                ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
                if (k > 0) {
                    float f12 = this.random.nextFloat() * 0.15f * 0.5f;
                    float f14 = this.random.nextFloat() * 0.15f * 0.5f;
                    poseStack.translate(f12, (float)k * 0.1f * 0.5f, f14);
                }
                this.renderItemLayingDown(poseStack, direction);
                Minecraft.getInstance().getItemRenderer().renderStatic(boardStack, ItemDisplayContext.FIXED, p_112311_, p_112312_, poseStack, p_112310_, plateBlockEntity.getLevel(), posLong);
                poseStack.popPose();
            }
        }
    }

    protected int getRenderAmount(ItemStack p_115043_) {
        int i = 1;
        if (p_115043_.getCount() > 48) {
            i = 5;
        } else if (p_115043_.getCount() > 32) {
            i = 4;
        } else if (p_115043_.getCount() > 16) {
            i = 3;
        } else if (p_115043_.getCount() > 1) {
            i = 2;
        }
        return i;
    }

    public void renderItemLayingDown(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.translate(0.5, 0.07, 0.5);
        float f = -direction.toYRot();
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f));
        matrixStackIn.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        matrixStackIn.scale(0.6f, 0.6f, 0.6f);
    }

    public void renderBlock(PoseStack matrixStackIn, Direction direction) {
        matrixStackIn.translate(0.5, 0.25, 0.5);
        float f = -direction.toYRot();
        matrixStackIn.mulPose((Quaternionfc)Axis.YP.rotationDegrees(f));
        matrixStackIn.scale(0.8f, 0.8f, 0.8f);
    }
}

