/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.screen;

import baguchi.tofucraft.client.recipe.TFCraftingTableRecipeBookComponent;
import baguchi.tofucraft.inventory.TFCraftingTableMenu;
import baguchi.tofucraft.mixin.client.GuiGraphicsAccessor;
import baguchi.tofucraft.registry.TofuFluids;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Rectangle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.screens.inventory.AbstractRecipeBookScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import org.joml.Matrix4f;

public class TfCraftingTableScreen
extends AbstractRecipeBookScreen<TFCraftingTableMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tofucraft", (String)"textures/gui/tf_crafting_table.png");
    private static final Rectangle PROGRESS_ARROW = new Rectangle(89, 34, 24, 17);

    public TfCraftingTableScreen(TFCraftingTableMenu screenContainer, Inventory inv, Component titleIn) {
        super((RecipeBookMenu)screenContainer, (RecipeBookComponent)new TFCraftingTableRecipeBookComponent(screenContainer), inv, titleIn);
    }

    protected ScreenPosition getRecipeBookButtonPosition() {
        return new ScreenPosition(this.leftPos + 5, this.height / 2 - 49);
    }

    protected void renderBg(GuiGraphics gui, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.minecraft == null) {
            return;
        }
        gui.blit(RenderType::guiTextured, BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        int heightInd = (int)(44.0f * (float)((TFCraftingTableMenu)this.menu).getTFEnergy() / (float)((TFCraftingTableMenu)this.menu).getTFMaxEnergy());
        if (heightInd > 0) {
            TfCraftingTableScreen.renderFluidStack(gui, gui.pose(), this.leftPos + 158, this.topPos + 69, 10, heightInd, (Fluid)TofuFluids.SOYMILK.get());
        }
        int l = ((TFCraftingTableMenu)this.menu).getCookProgressionScaled();
        gui.blit(RenderType::guiTextured, BACKGROUND_TEXTURE, this.leftPos + TfCraftingTableScreen.PROGRESS_ARROW.x, this.topPos + TfCraftingTableScreen.PROGRESS_ARROW.y, 176.0f, 15.0f, l + 1, TfCraftingTableScreen.PROGRESS_ARROW.height, 256, 256);
    }

    public static void renderFluidStack(GuiGraphics guiGraphics, PoseStack stack, int xPosition, int yPosition, int desiredWidth, int desiredHeight, Fluid fluid) {
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(TextureAtlas.LOCATION_BLOCKS).apply(IClientFluidTypeExtensions.of((Fluid)fluid).getStillTexture());
        int color = IClientFluidTypeExtensions.of((Fluid)fluid).getTintColor();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        int xTileCount = desiredWidth / 16;
        int xRemainder = desiredWidth - xTileCount * 16;
        int yTileCount = desiredHeight / 16;
        int yRemainder = desiredHeight - yTileCount * 16;
        float uMin = sprite.getU0();
        float uMax = sprite.getU1();
        float vMin = sprite.getV0();
        float vMax = sprite.getV1();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        VertexConsumer vertexBuffer = ((GuiGraphicsAccessor)guiGraphics).bufferSource().getBuffer(RenderType.guiTextured((ResourceLocation)TextureAtlas.LOCATION_BLOCKS));
        Matrix4f matrix4f = stack.last().pose();
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            int width;
            int n = width = xTile == xTileCount ? xRemainder : 16;
            if (width == 0) break;
            int x = xPosition + xTile * 16;
            int maskRight = 16 - width;
            int shiftedX = x + 16 - maskRight;
            float uLocalDif = uDif * (float)maskRight / 16.0f;
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : 16;
                if (height == 0) continue block0;
                int y = yPosition - (yTile + 1) * 16;
                int maskTop = 16 - height;
                float vLocalDif = vDif * (float)maskTop / 16.0f;
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + 16), 0.0f).setUv(uMin + uLocalDif, vMax).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + 16), 0.0f).setUv(uMax, vMax).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)shiftedX, (float)(y + maskTop), 0.0f).setUv(uMax, vMin + vLocalDif).setColor(red, green, blue, alpha);
                vertexBuffer.addVertex(matrix4f, (float)x, (float)(y + maskTop), 0.0f).setUv(uMin + uLocalDif, vMin + vLocalDif).setColor(red, green, blue, alpha);
            }
        }
    }
}

