/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.client.sound;

import baguchi.tofucraft.api.TofuBossMob;
import baguchi.tofucraft.client.sound.MusicSoundInstance;
import baguchi.tofucraft.network.GuiHooks;
import baguchi.tofucraft.registry.TofuTags;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.WinScreen;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class TofuMusicManager {
    private static final int FADE_LIMIT = 50;
    private static final RandomSource random = RandomSource.create();
    private static final Minecraft minecraft = Minecraft.getInstance();
    private static final MusicManager musicManager = Minecraft.getInstance().getMusicManager();
    @Nullable
    private static SoundInstance currentMusic;
    private static int nextSongDelay;
    private static Integer fade;

    public static void tick() {
        Music music = TofuMusicManager.getSituationalMusic();
        Object object = currentMusic;
        if (object instanceof MusicSoundInstance) {
            MusicSoundInstance musicSoundInstance = (MusicSoundInstance)((Object)object);
            if (musicSoundInstance.isBossMusic()) {
                if (music == null || !TofuMusicManager.isTofuBossMusic(music)) {
                    if (fade == null) {
                        fade = 0;
                    }
                    musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                    object = fade;
                    fade = fade + 1;
                    if (fade >= 50) {
                        fade = null;
                        minecraft.getSoundManager().stop(currentMusic);
                        currentMusic = null;
                        nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.nextInt((RandomSource)random, (int)50, (int)50));
                    }
                }
            } else if (music != null && TofuMusicManager.isTofuBossMusic(music)) {
                if (fade == null) {
                    fade = 0;
                }
                musicSoundInstance.setVolume((float)Math.exp(-((double)fade.intValue() / 16.666666666666668)));
                object = fade;
                fade = fade + 1;
                if (fade >= 50) {
                    fade = null;
                    minecraft.getSoundManager().stop(currentMusic);
                    currentMusic = null;
                    nextSongDelay = 16;
                }
            }
        }
        if (music != null) {
            if (currentMusic != null && fade == null) {
                if (!((SoundEvent)music.getEvent().value()).location().equals((Object)currentMusic.getLocation()) && music.replaceCurrentMusic()) {
                    minecraft.getSoundManager().stop(currentMusic);
                    nextSongDelay = Mth.nextInt((RandomSource)random, (int)0, (int)(music.getMinDelay() / 2));
                }
                if (!minecraft.getSoundManager().isActive(currentMusic)) {
                    currentMusic = null;
                    nextSongDelay = Math.min(nextSongDelay, Mth.nextInt((RandomSource)random, (int)music.getMinDelay(), (int)music.getMaxDelay()));
                }
            }
            nextSongDelay = Math.min(nextSongDelay, music.getMaxDelay());
            if (currentMusic == null && nextSongDelay-- <= 0) {
                TofuMusicManager.startPlaying(music);
            }
        } else if (currentMusic == null || !minecraft.getSoundManager().isActive(currentMusic)) {
            currentMusic = null;
            if (nextSongDelay-- <= 0) {
                nextSongDelay = Math.min(Integer.MAX_VALUE, Mth.nextInt((RandomSource)random, (int)50, (int)100));
            }
        }
    }

    public static void startPlaying(Music music) {
        musicManager.stopPlaying();
        currentMusic = TofuMusicManager.isTofuBossMusic(music) ? MusicSoundInstance.forBossMusic((SoundEvent)music.getEvent().value()) : MusicSoundInstance.forMusic((SoundEvent)music.getEvent().value());
        if (currentMusic.getSound() != SoundManager.EMPTY_SOUND) {
            minecraft.getSoundManager().play(currentMusic);
        }
        nextSongDelay = Integer.MAX_VALUE;
    }

    public static void stopPlaying() {
        if (currentMusic != null) {
            minecraft.getSoundManager().stop(currentMusic);
            currentMusic = null;
        }
        nextSongDelay += 100;
    }

    @Nullable
    public static SoundInstance getCurrentMusic() {
        return currentMusic;
    }

    @Nullable
    public static <T extends LivingEntity> Music getSituationalMusic() {
        Music bossMusic;
        T boss;
        if (!(TofuMusicManager.minecraft.screen instanceof WinScreen) && TofuMusicManager.minecraft.player != null && TofuMusicManager.isTofuBossMusicActive() && (boss = TofuMusicManager.getBossFromFight()) != null && boss.getHealth() > 0.0f && (bossMusic = ((TofuBossMob)boss).getBossMusic()) != null) {
            return ((TofuBossMob)boss).getBossMusic();
        }
        return null;
    }

    public static boolean isTofuBossMusic(Music music) {
        return music.getEvent().is(TofuTags.SoundEvents.BOSS_MUSIC);
    }

    public static boolean isTofuBossMusicActive() {
        return TofuMusicManager.minecraft.gui.getBossOverlay().shouldPlayMusic();
    }

    public static <T extends LivingEntity> T getBossFromFight() {
        for (Map.Entry<UUID, Integer> event : GuiHooks.BOSS_EVENTS.entrySet()) {
            UUID eventUUID = event.getKey();
            Entity entity = TofuMusicManager.minecraft.player.level().getEntity(event.getValue().intValue());
            if (!(entity instanceof LivingEntity) || !(entity instanceof TofuBossMob)) continue;
            return (T)((LivingEntity)entity);
        }
        return null;
    }

    static {
        nextSongDelay = 100;
        fade = null;
    }
}

