/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.dispenser;

import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.ProjectileDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DamageableProjectileDispenseBehavior
extends ProjectileDispenseBehavior {
    private final ProjectileItem projectileItem;
    private final ProjectileItem.DispenseConfig dispenseConfig;

    public DamageableProjectileDispenseBehavior(Item p_338781_) {
        super(p_338781_);
        ProjectileItem projectileitem;
        if (!(p_338781_ instanceof ProjectileItem)) {
            throw new IllegalArgumentException(String.valueOf(p_338781_) + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        this.projectileItem = projectileitem = (ProjectileItem)p_338781_;
        this.dispenseConfig = projectileitem.createDispenseConfig();
    }

    public ItemStack execute(BlockSource p_123366_, ItemStack p_123367_) {
        ServerLevel level = p_123366_.level();
        Position position = DispenserBlock.getDispensePosition((BlockSource)p_123366_);
        Direction direction = (Direction)p_123366_.state().getValue((Property)DispenserBlock.FACING);
        for (int i = 0; i < this.shootCount(); ++i) {
            Projectile projectile = this.projectileItem.asProjectile((Level)level, position, p_123367_, direction);
            projectile.shoot((double)direction.getStepX(), (double)((float)direction.getStepY() + 0.1f), (double)direction.getStepZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
            level.addFreshEntity((Entity)projectile);
        }
        p_123367_.hurtAndBreak(1, level, null, p_348118_ -> {});
        return p_123367_;
    }

    protected int shootCount() {
        return 1;
    }
}

