/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuSounds;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTofunian
extends AgeableMob
implements InventoryCarrier,
Npc,
Merchant {
    private static final EntityDimensions BABY_DIMENSIONS = TofuEntityTypes.TOFUNIAN.get().getDimensions().scale(0.5f).withEyeHeight(0.3f);
    private static final EntityDataAccessor<Integer> DATA_UNHAPPY_COUNTER = SynchedEntityData.defineId(AbstractTofunian.class, (EntityDataSerializer)EntityDataSerializers.INT);
    @Nullable
    private Player tradingPlayer;
    @Nullable
    protected MerchantOffers offers;
    private final SimpleContainer inventory = new SimpleContainer(8);
    protected int idleAnimationTimeout;
    public final AnimationState idleAnimationState = new AnimationState();

    public AbstractTofunian(EntityType<? extends AbstractTofunian> type, Level worldIn) {
        super(type, worldIn);
        this.setPathfindingMalus(PathType.DANGER_FIRE, 16.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
    }

    public void tick() {
        super.tick();
        if (this.getUnhappyCounter() > 0) {
            this.setUnhappyCounter(this.getUnhappyCounter() - 1);
        }
        if (this.level().isClientSide()) {
            this.setupAnimationStates();
        }
    }

    public void setupAnimationStates() {
        if (!this.isSleeping()) {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = this.random.nextInt(40) + 80;
                this.idleAnimationState.start(this.tickCount);
            } else {
                --this.idleAnimationTimeout;
            }
        }
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return TofuSounds.TOFUNIAN_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource p_21239_) {
        return TofuSounds.TOFUNIAN_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return TofuSounds.TOFUNIAN_DEATH.get();
    }

    protected SoundEvent getTradeUpdatedSound(boolean p_213721_1_) {
        return p_213721_1_ ? TofuSounds.TOFUNIAN_YES.get() : TofuSounds.TOFUNIAN_NO.get();
    }

    public SoundEvent getNotifyTradeSound() {
        return TofuSounds.TOFUNIAN_YES.get();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_35282_, DifficultyInstance p_35283_, EntitySpawnReason p_35284_, @Nullable SpawnGroupData p_35285_) {
        if (p_35285_ == null) {
            p_35285_ = new AgeableMob.AgeableMobGroupData(false);
        }
        return super.finalizeSpawn(p_35282_, p_35283_, p_35284_, p_35285_);
    }

    public int getUnhappyCounter() {
        return (Integer)this.entityData.get(DATA_UNHAPPY_COUNTER);
    }

    public void setUnhappyCounter(int p_35320_) {
        this.entityData.set(DATA_UNHAPPY_COUNTER, (Object)p_35320_);
    }

    public int getVillagerXp() {
        return 0;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_UNHAPPY_COUNTER, (Object)0);
    }

    public void setTradingPlayer(@Nullable Player p_35314_) {
        this.tradingPlayer = p_35314_;
    }

    @Nullable
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public MerchantOffers getOffers() {
        if (this.offers == null) {
            this.offers = new MerchantOffers();
            this.updateTrades();
        }
        return this.offers;
    }

    public void overrideOffers(@Nullable MerchantOffers p_35276_) {
    }

    public void overrideXp(int p_35322_) {
    }

    public void notifyTrade(MerchantOffer p_35274_) {
        p_35274_.increaseUses();
        this.ambientSoundTime = -this.getAmbientSoundInterval();
        this.rewardTradeXp(p_35274_);
        if (this.tradingPlayer instanceof ServerPlayer) {
            // empty if block
        }
    }

    protected abstract void rewardTradeXp(MerchantOffer var1);

    public boolean showProgressBar() {
        return true;
    }

    public void notifyTradeUpdated(ItemStack p_35316_) {
        if (!this.level().isClientSide && this.ambientSoundTime > -this.getAmbientSoundInterval() + 20) {
            this.ambientSoundTime = -this.getAmbientSoundInterval();
            this.playSound(this.getTradeUpdatedSound(!p_35316_.isEmpty()), this.getSoundVolume(), this.getVoicePitch());
        }
    }

    public void addAdditionalSaveData(CompoundTag p_35301_) {
        super.addAdditionalSaveData(p_35301_);
        MerchantOffers merchantoffers = this.getOffers();
        if (!merchantoffers.isEmpty()) {
            p_35301_.put("Offers", (Tag)MerchantOffers.CODEC.encodeStart((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)merchantoffers).getOrThrow());
        }
        this.writeInventoryToTag(p_35301_, (HolderLookup.Provider)this.registryAccess());
    }

    public void readAdditionalSaveData(CompoundTag p_35290_) {
        super.readAdditionalSaveData(p_35290_);
        if (p_35290_.contains("Offers")) {
            MerchantOffers.CODEC.parse((DynamicOps)this.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)p_35290_.get("Offers")).resultOrPartial(Util.prefix((String)"Failed to load offers: ", arg_0 -> ((Logger)TofuCraftReload.LOGGER).warn(arg_0))).ifPresent(p_323775_ -> {
                this.offers = p_323775_;
            });
        }
        this.readInventoryFromTag(p_35290_, (HolderLookup.Provider)this.registryAccess());
    }

    protected EntityDimensions getDefaultDimensions(Pose p_316700_) {
        return super.getDefaultDimensions(p_316700_);
    }

    protected void stopTrading() {
        this.setTradingPlayer(null);
    }

    public void die(DamageSource p_35270_) {
        super.die(p_35270_);
        this.stopTrading();
    }

    protected void addParticlesAroundSelf(ParticleOptions p_35288_) {
        for (int i = 0; i < 5; ++i) {
            double d0 = this.random.nextGaussian() * 0.02;
            double d1 = this.random.nextGaussian() * 0.02;
            double d2 = this.random.nextGaussian() * 0.02;
            this.level().addParticle(p_35288_, this.getRandomX(1.0), this.getRandomY() + 1.0, this.getRandomZ(1.0), d0, d1, d2);
        }
    }

    public boolean canBeLeashed(Player p_35272_) {
        return false;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public SlotAccess getSlot(int p_149995_) {
        int i = p_149995_ - 300;
        return i >= 0 && i < this.inventory.getContainerSize() ? SlotAccess.forContainer((Container)this.inventory, (int)i) : super.getSlot(p_149995_);
    }

    protected abstract void updateTrades();

    protected void addOffersFromItemListings(MerchantOffers p_35278_, VillagerTrades.ItemListing[] p_35279_, int p_35280_) {
        HashSet set = Sets.newHashSet();
        if (p_35279_.length > p_35280_) {
            while (set.size() < p_35280_) {
                set.add(this.random.nextInt(p_35279_.length));
            }
        } else {
            for (int i = 0; i < p_35279_.length; ++i) {
                set.add(i);
            }
        }
        for (Integer integer : set) {
            VillagerTrades.ItemListing villagertrades$itemlisting = p_35279_[integer];
            MerchantOffer merchantoffer = villagertrades$itemlisting.getOffer((Entity)this, this.random);
            if (merchantoffer == null) continue;
            p_35278_.add((Object)merchantoffer);
        }
    }

    public Vec3 getRopeHoldPosition(float p_35318_) {
        float f = Mth.lerp((float)p_35318_, (float)this.yBodyRotO, (float)this.yBodyRot) * ((float)Math.PI / 180);
        Vec3 vec3 = new Vec3(0.0, this.getBoundingBox().getYsize() - 1.0, 0.2);
        return this.getPosition(p_35318_).add(vec3.yRot(-f));
    }

    public boolean isClientSide() {
        return this.level().isClientSide;
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        if (super.considersEntityAsAlly(p_360600_)) {
            return true;
        }
        if (p_360600_.getType() == TofuEntityTypes.TOFU_GOLEM) {
            return this.getTeam() == null && p_360600_.getTeam() == null;
        }
        return !(p_360600_ instanceof AbstractTofunian) ? false : this.getTeam() == null && p_360600_.getTeam() == null;
    }

    public boolean stillValid(Player p_383034_) {
        return this.getTradingPlayer() == p_383034_ && this.isAlive() && p_383034_.canInteractWithEntity((Entity)this, 4.0);
    }
}

