/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.entity;

import baguchi.tofucraft.api.TofuBossMob;
import baguchi.tofucraft.entity.AbstractTofunian;
import baguchi.tofucraft.entity.control.StafeableFlyingMoveControl;
import baguchi.tofucraft.entity.goal.ChargeGoal;
import baguchi.tofucraft.entity.goal.SpinAttackGoal;
import baguchi.tofucraft.entity.projectile.FukumameEntity;
import baguchi.tofucraft.entity.projectile.SoyballEntity;
import baguchi.tofucraft.network.BossInfoPacket;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuSounds;
import baguchi.tofucraft.registry.TofuStructures;
import baguchi.tofucraft.utils.CombatUtils;
import baguchi.tofucraft.world.TofuData;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class TofuGandlem
extends Monster
implements RangedAttackMob,
TofuBossMob {
    private final ServerBossEvent bossEvent = (ServerBossEvent)new ServerBossEvent(this.getDisplayName(), BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS).setPlayBossMusic(true);
    private static final EntityDataAccessor<Boolean> DATA_ID_SHOOT = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_RUSH = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_ID_SLEEP = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Byte> DATA_CHARGE_FLAGS_ID = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Float> DATA_CHARGE_HEALTH = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<String> ACTION = SynchedEntityData.defineId(TofuGandlem.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final UniformInt RUSH_COOLDOWN = UniformInt.of((int)200, (int)400);
    private static final UniformInt CHARGE_COOLDOWN = UniformInt.of((int)400, (int)600);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState shootAnimationState = new AnimationState();
    public final AnimationState shootingAnimationState = new AnimationState();
    public final AnimationState rushAnimationState = new AnimationState();
    public final AnimationState deathAnimationState = new AnimationState();
    public final AnimationState chargeAnimationState = new AnimationState();
    public final AnimationState chargeStopAnimationState = new AnimationState();
    public final AnimationState chargeFailAnimationState = new AnimationState();
    public int failTick;
    private int actionTick;
    @Nullable
    private BlockPos homePos;
    private static final Music GANDLEM_MUSIC = new Music(TofuSounds.TOFU_DUNGEON_BGM, 0, 0, true);

    public TofuGandlem(EntityType<? extends TofuGandlem> p_27508_, Level p_27509_) {
        super(p_27508_, p_27509_);
        this.moveControl = new StafeableFlyingMoveControl((Mob)this, 20, false);
        this.xpReward = 60;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_ID_SHOOT, (Object)false);
        builder.define(DATA_ID_RUSH, (Object)false);
        builder.define(DATA_ID_SLEEP, (Object)false);
        builder.define(DATA_CHARGE_FLAGS_ID, (Object)0);
        builder.define(DATA_CHARGE_HEALTH, (Object)Float.valueOf(0.0f));
        builder.define(ACTION, (Object)Actions.NORMAL.name());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new DoNothingGoal());
        this.goalSelector.addGoal(3, (Goal)new ChargeGoal(this, CHARGE_COOLDOWN));
        this.goalSelector.addGoal(4, (Goal)new SpinAttackGoal(this, RUSH_COOLDOWN));
        this.goalSelector.addGoal(5, (Goal)new AttackGoal(this));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 0.9));
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 6.0f));
        this.goalSelector.addGoal(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractTofunian.class, true));
    }

    protected PathNavigation createNavigation(Level p_218342_) {
        FlyingPathNavigation flyingpathnavigation = new FlyingPathNavigation((Mob)this, p_218342_);
        flyingpathnavigation.setCanOpenDoors(false);
        flyingpathnavigation.setCanFloat(true);
        return flyingpathnavigation;
    }

    public boolean isShoot() {
        return (Boolean)this.entityData.get(DATA_ID_SHOOT);
    }

    public void setShoot(boolean shoot) {
        this.entityData.set(DATA_ID_SHOOT, (Object)shoot);
    }

    public boolean hasChargeHealth() {
        return ((Float)this.entityData.get(DATA_CHARGE_HEALTH)).floatValue() > 0.0f;
    }

    public float getChargeHealth() {
        return ((Float)this.entityData.get(DATA_CHARGE_HEALTH)).floatValue();
    }

    public void setChargeHealth(float chargeHealth) {
        this.entityData.set(DATA_CHARGE_HEALTH, (Object)Float.valueOf(chargeHealth));
    }

    public boolean isRush() {
        return (Boolean)this.entityData.get(DATA_ID_RUSH);
    }

    public void setRush(boolean rush) {
        this.entityData.set(DATA_ID_RUSH, (Object)rush);
    }

    public boolean isSleepSelf() {
        return (Boolean)this.entityData.get(DATA_ID_SLEEP);
    }

    public void setSleepSelf(boolean sleep) {
        this.bossEvent.setVisible(!sleep);
        this.entityData.set(DATA_ID_SLEEP, (Object)sleep);
    }

    private void setChargeFlag(int p_28533_, boolean p_28534_) {
        if (p_28534_) {
            this.entityData.set(DATA_CHARGE_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_CHARGE_FLAGS_ID) | p_28533_)));
        } else {
            this.entityData.set(DATA_CHARGE_FLAGS_ID, (Object)((byte)((Byte)this.entityData.get(DATA_CHARGE_FLAGS_ID) & ~p_28533_)));
        }
    }

    private boolean getChargeFlag(int p_28609_) {
        return ((Byte)this.entityData.get(DATA_CHARGE_FLAGS_ID) & p_28609_) != 0;
    }

    public boolean isFullCharge() {
        return this.getChargeFlag(16);
    }

    public void setFullCharge(boolean fullcharge) {
        this.setChargeFlag(16, fullcharge);
        if (fullcharge) {
            this.setChargeHealth(40.0f);
        }
    }

    public void setCharging(boolean p_28615_) {
        this.setChargeFlag(4, p_28615_);
    }

    public boolean isCharging() {
        return this.getChargeFlag(4);
    }

    public void setChargeFailed(boolean p_28617_) {
        this.setChargeFlag(8, p_28617_);
        if (p_28617_) {
            this.setAction(Actions.CHARGE_FAILED);
        }
    }

    public boolean isChargeFailed() {
        return this.getChargeFlag(8);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("Sleep", this.isSleepSelf());
        compound.putBoolean("FullCharge", this.isFullCharge());
        compound.putFloat("ChargeHealth", this.getChargeHealth());
        if (this.homePos != null) {
            compound.store("HomePos", BlockPos.CODEC, (Object)this.homePos);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setSleepSelf(compound.getBooleanOr("Sleep", false));
        this.setFullCharge(compound.getBooleanOr("FullCharge", false));
        this.setChargeHealth(compound.getFloatOr("ChargeHealth", 0.0f));
        if (compound.contains("HomePos")) {
            this.homePos = compound.read("HomePos", BlockPos.CODEC).orElse(null);
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, EntitySpawnReason p_21436_, @Nullable SpawnGroupData p_21437_) {
        if (p_21436_ == EntitySpawnReason.STRUCTURE) {
            this.homePos = this.blockPosition();
        }
        return super.finalizeSpawn(p_21434_, p_21435_, p_21436_, p_21437_);
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public boolean removeWhenFarAway(double p_21542_) {
        return false;
    }

    public int getAmbientSoundInterval() {
        return 120;
    }

    public void tick() {
        if (this.level().isClientSide()) {
            if (this.isAlive() && !this.isSleepSelf()) {
                this.idleAnimationState.startIfStopped(this.tickCount);
            } else {
                this.idleAnimationState.stop();
                this.rushAnimationState.stop();
            }
            if (this.isAlive() && this.isShoot()) {
                this.shootAnimationState.startIfStopped(this.tickCount);
            } else {
                this.shootAnimationState.stop();
                this.shootingAnimationState.stop();
            }
        } else {
            this.bossEvent.setProgress(this.getHealth() / this.getMaxHealth());
        }
        if (this.isAlive() && this.isRush()) {
            Vec3 movement = this.getDeltaMovement();
            this.checkRushAttack(this.getBoundingBox(), this.getBoundingBox().expandTowards(movement.x, movement.y, movement.z));
        }
        if (this.isChargeFailed() && ++this.failTick > 80) {
            this.setChargeFailed(false);
            this.failTick = 0;
        }
        super.tick();
    }

    public boolean hurtServer(ServerLevel serverLevel, DamageSource p_21016_, float amount) {
        if (p_21016_.getDirectEntity() instanceof LivingEntity && this.isSleepSelf()) {
            this.setSleepSelf(false);
        }
        if (this.isCharging() && this.random.nextFloat() < 0.015f * amount) {
            this.setCharging(false);
            this.setChargeFailed(true);
            this.playSound((SoundEvent)SoundEvents.SHIELD_BREAK.value(), 2.0f, 1.0f);
        }
        if (this.hasChargeHealth()) {
            this.setChargeHealth(this.getChargeHealth() - amount);
        }
        if (this.isFullCharge() && !this.hasChargeHealth()) {
            this.setFullCharge(false);
            this.setChargeFailed(true);
            this.playSound((SoundEvent)SoundEvents.SHIELD_BREAK.value(), 2.0f, 1.0f);
        } else if (this.isFullCharge()) {
            return super.hurtServer(serverLevel, p_21016_, amount * 0.45f);
        }
        if (p_21016_.is(DamageTypeTags.IS_PROJECTILE)) {
            return super.hurtServer(serverLevel, p_21016_, amount * 0.8f);
        }
        return super.hurtServer(serverLevel, p_21016_, amount);
    }

    protected void checkRushAttack(AABB p_21072_, AABB p_21073_) {
        AABB aabb = p_21072_.minmax(p_21073_);
        List list = this.level().getEntities((Entity)this, aabb);
        if (!list.isEmpty()) {
            int i = 0;
            if (i < list.size()) {
                Entity entity = (Entity)list.get(i);
                this.rushAttack(entity);
            }
        } else if (this.horizontalCollision && this.tickCount % 3 == 0) {
            boolean flag = false;
            int l = Mth.floor((float)(this.getBbWidth() / 2.0f + 1.0f));
            int i1 = Mth.floor((float)this.getBbHeight()) + 1;
            for (BlockPos blockpos : BlockPos.betweenClosed((int)(this.getBlockX() - l), (int)this.getBlockY(), (int)(this.getBlockZ() - l), (int)(this.getBlockX() + l), (int)(this.getBlockY() + i1), (int)(this.getBlockZ() + l))) {
                BlockState blockstate = this.level().getBlockState(blockpos);
                if (!blockstate.canEntityDestroy((BlockGetter)this.level(), blockpos, (Entity)this) || !EventHooks.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
                flag = this.level().destroyBlock(blockpos, true, (Entity)this) || flag;
            }
            if (flag) {
                this.level().levelEvent(null, 1022, this.blockPosition(), 0);
            }
            this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 2.0f, 1.0f);
        }
    }

    public void rushAttack(Entity p_36347_) {
        DamageSource source = this.damageSources().mobAttack((LivingEntity)this);
        if (p_36347_.isAttackable() && p_36347_ instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)p_36347_;
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (p_36347_.hurtServer(serverLevel, source, 16.0f)) {
                    float i = (float)this.getAttributeValue(Attributes.ATTACK_KNOCKBACK);
                    if ((i += 5.0f) > 0.0f) {
                        if (p_36347_ instanceof LivingEntity) {
                            ((LivingEntity)p_36347_).knockback((double)(i * 0.5f), (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
                        } else {
                            p_36347_.push((double)(-Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))) * i * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180))) * i * 0.5f));
                        }
                        this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 2.0f, 1.0f);
                    }
                }
                if (CombatUtils.isBlockingWithOutCheck(serverLevel, living, source, 16.0f) >= 15.0f) {
                    this.setRush(false);
                    this.setChargeFailed(true);
                    this.playSound(SoundEvents.PLAYER_ATTACK_KNOCKBACK, 2.0f, 1.0f);
                    if (living.isBlocking() && living.getItemBlockingWith() != null && living instanceof Player) {
                        Player player = (Player)living;
                        player.getCooldowns().addCooldown(living.getItemBlockingWith(), 100);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleEntityEvent(byte p_70103_1_) {
        if (p_70103_1_ == 4) {
            this.attackAnimationState.start(this.tickCount);
        } else if (p_70103_1_ == 5) {
            this.shootingAnimationState.start(this.tickCount);
        } else if (p_70103_1_ == 7) {
            this.deathAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(p_70103_1_);
        }
    }

    public boolean doHurtTarget(ServerLevel serverLevel, Entity p_21372_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        return super.doHurtTarget(serverLevel, p_21372_);
    }

    public void travel(Vec3 p_218382_) {
        if (this.isLocalInstanceAuthoritative()) {
            if (this.isInWater()) {
                this.moveRelative(0.02f, p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.8f));
            } else if (this.isInLava()) {
                this.moveRelative(0.02f, p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale(0.5));
            } else {
                this.moveRelative(this.getSpeed(), p_218382_);
                this.move(MoverType.SELF, this.getDeltaMovement());
                this.setDeltaMovement(this.getDeltaMovement().scale((double)0.91f));
            }
        }
        this.calculateEntityAnimation(false);
    }

    public void aiStep() {
        if (this.isFullCharge() && this.level().isClientSide) {
            for (int i = 0; i < 2; ++i) {
                this.level().addParticle((ParticleOptions)TofuParticleTypes.TOFU_PORTAL.get(), this.getRandomX(0.5), this.getRandomY() - 0.25, this.getRandomZ(0.5), (this.random.nextDouble() - 0.5) * 2.0, -this.random.nextDouble(), (this.random.nextDouble() - 0.5) * 2.0);
            }
        }
        super.aiStep();
        if (this.isAlive() && !this.isSleepSelf()) {
            this.calculateFlapping();
        }
        if (this.isSleepSelf() && this.getTarget() != null) {
            this.setSleepSelf(false);
            this.playSound(SoundEvents.BEACON_ACTIVATE, 3.0f, 1.0f);
        }
        if (!this.level().isClientSide && this.isAlive() && this.tickCount % 10 == 0 && this.isCharging()) {
            this.heal(4.0f);
        }
        this.actionTicks();
        if (this.level().isClientSide) {
            this.actionAnimations(this.getAction(), true);
        }
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> p_146754_) {
        if (ACTION.equals(p_146754_)) {
            this.actionAnimations(this.getAction(), false);
        }
        if (DATA_ID_RUSH.equals(p_146754_)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(p_146754_);
    }

    public Actions getAction() {
        return Actions.get((String)this.entityData.get(ACTION));
    }

    public void setAction(Actions action) {
        this.entityData.set(ACTION, (Object)action.name());
        this.actionTick = 0;
    }

    public void actionTicks() {
        if (this.getAction().tick > -1) {
            if (this.getAction().tick <= this.actionTick) {
                this.actionTick = 0;
                this.setAction(Actions.NORMAL);
            } else {
                ++this.actionTick;
            }
        } else {
            this.actionTick = 0;
        }
    }

    public void actionAnimations(Actions actions, boolean loop) {
        if (loop && actions.loop || !loop && !actions.loop) {
            switch (actions.ordinal()) {
                case 1: {
                    this.attackAnimationState.stop();
                    this.shootAnimationState.stop();
                    this.shootingAnimationState.stop();
                    this.stopAnimations();
                    this.rushAnimationState.start(this.tickCount);
                    break;
                }
                case 2: {
                    this.attackAnimationState.stop();
                    this.shootAnimationState.stop();
                    this.shootingAnimationState.stop();
                    this.stopAnimations();
                    this.chargeAnimationState.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.attackAnimationState.stop();
                    this.shootAnimationState.stop();
                    this.shootingAnimationState.stop();
                    this.stopAnimations();
                    this.chargeStopAnimationState.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.attackAnimationState.stop();
                    this.shootAnimationState.stop();
                    this.shootingAnimationState.stop();
                    this.stopAnimations();
                    this.chargeFailAnimationState.start(this.tickCount);
                    break;
                }
                default: {
                    this.stopAnimations();
                }
            }
        }
    }

    public void stopAnimations() {
        this.chargeAnimationState.stop();
        this.chargeFailAnimationState.stop();
        this.chargeStopAnimationState.stop();
        this.rushAnimationState.stop();
    }

    private void calculateFlapping() {
        Vec3 vec3 = this.getDeltaMovement();
    }

    public void die(DamageSource p_21014_) {
        super.die(p_21014_);
        this.playSound(SoundEvents.BEACON_DEACTIVATE, 2.0f, 1.0f);
        if (!this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                Structure structure;
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.homePos != null && (structure = (Structure)serverLevel.registryAccess().lookupOrThrow(Registries.STRUCTURE).getValueOrThrow(TofuStructures.TOFU_CASTLE)) != null) {
                    TofuData data = TofuData.get((Level)serverLevel);
                    StructureStart structureStart = serverLevel.structureManager().getStructureAt(this.homePos, structure);
                    if (structureStart.isValid() && !data.getBeatenDungeons().contains(structureStart.getBoundingBox())) {
                        data.addBeatenDungeons(structureStart.getBoundingBox());
                    }
                }
            }
        }
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 38) {
            this.playSound((SoundEvent)SoundEvents.ITEM_BREAK.value(), 1.0f, 1.4f);
        }
        if (this.deathTime == 40) {
            this.playSound((SoundEvent)SoundEvents.ITEM_BREAK.value(), 1.0f, 1.35f);
        }
        if (this.deathTime == 100 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    public boolean causeFallDamage(float p_148989_, float p_148990_, DamageSource p_148991_) {
        return false;
    }

    protected void checkFallDamage(double p_29370_, boolean p_29371_, BlockState p_29372_, BlockPos p_29373_) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, 300.0).add(Attributes.FOLLOW_RANGE, 28.0).add(Attributes.MOVEMENT_SPEED, 0.11).add(Attributes.FLYING_SPEED, 0.11).add(Attributes.ATTACK_KNOCKBACK, (double)0.9f).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.ARMOR, 10.0).add(Attributes.ARMOR_TOUGHNESS, 2.0).add(Attributes.ATTACK_DAMAGE, 4.0);
    }

    protected int decreaseAirSupply(int p_28882_) {
        return p_28882_;
    }

    public void push(Entity p_21294_) {
        if (!this.isSleepSelf()) {
            super.push(p_21294_);
        }
    }

    protected boolean considersEntityAsAlly(Entity p_360600_) {
        if (super.considersEntityAsAlly(p_360600_)) {
            return true;
        }
        if (p_360600_.getType() == TofuEntityTypes.TOFU_GANDLEM) {
            return this.getTeam() == null && p_360600_.getTeam() == null;
        }
        return false;
    }

    public void startSeenByPlayer(ServerPlayer player) {
        super.startSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Display(this.bossEvent.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (this.homePos != null) {
            this.bossEvent.addPlayer(player);
        }
    }

    public void stopSeenByPlayer(ServerPlayer player) {
        super.stopSeenByPlayer(player);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new BossInfoPacket.Remove(this.bossEvent.getId(), this.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.bossEvent.removePlayer(player);
    }

    protected EntityDimensions getDefaultDimensions(Pose p_21047_) {
        EntityDimensions entitydimensions = super.getDefaultDimensions(p_21047_);
        return this.isRush() ? EntityDimensions.fixed((float)entitydimensions.width(), (float)(entitydimensions.height() * 0.45f)) : entitydimensions;
    }

    public void performRangedAttack(LivingEntity p_29912_, float p_29913_) {
        this.playSound(SoundEvents.SHULKER_SHOOT, 3.0f, 1.0f);
        if (this.isFullCharge()) {
            for (int i = 0; i < 4; ++i) {
                SoyballEntity fukumame = new SoyballEntity(this.level(), (LivingEntity)this);
                double d1 = p_29912_.getX() - this.getX();
                double d2 = p_29912_.getEyeY() - this.getEyeY();
                double d3 = p_29912_.getZ() - this.getZ();
                float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.25f;
                fukumame.shoot(d1, d2 + (double)f, d3, 1.0f, 2.0f + p_29913_);
                fukumame.damage = 3.0f;
                this.level().addFreshEntity((Entity)fukumame);
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                FukumameEntity fukumame = new FukumameEntity(this.level(), (LivingEntity)this);
                double d1 = p_29912_.getX() - this.getX();
                double d2 = p_29912_.getEyeY() - this.getEyeY();
                double d3 = p_29912_.getZ() - this.getZ();
                float f = Mth.sqrt((float)((float)(d1 * d1 + d3 * d3))) * 0.2f;
                fukumame.shoot(d1, d2 + (double)f, d3, 1.0f, 2.0f + p_29913_);
                fukumame.damage = 1.0f;
                this.level().addFreshEntity((Entity)fukumame);
            }
        }
    }

    @Override
    public Music getBossMusic() {
        return null;
    }

    public static enum Actions {
        NORMAL(true, -1),
        START_RUSH(false, 112),
        CHARGE(false, 120),
        CHARGE_STOP(false, 13),
        CHARGE_FAILED(false, 60),
        SLEEP(true, -1);

        private final boolean loop;
        private final int tick;

        private Actions(boolean loop, int tick) {
            this.loop = loop;
            this.tick = tick;
        }

        public static Actions get(String nameIn) {
            for (Actions role : Actions.values()) {
                if (!role.name().equals(nameIn)) continue;
                return role;
            }
            return NORMAL;
        }
    }

    class DoNothingGoal
    extends Goal {
        public DoNothingGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            return TofuGandlem.this.isSleepSelf() || TofuGandlem.this.isChargeFailed();
        }
    }

    static class AttackGoal
    extends Goal {
        private final TofuGandlem gandlem;
        private int attackStep;
        private int attackTime;
        private int lastSeen;
        private boolean strafingClockwise;
        private boolean strafingBackwards;
        private int strafingTime = -1;

        public AttackGoal(TofuGandlem p_32247_) {
            this.gandlem = p_32247_;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean canUse() {
            LivingEntity livingentity = this.gandlem.getTarget();
            return livingentity != null && livingentity.isAlive() && this.gandlem.canAttack(livingentity);
        }

        public void start() {
            this.attackStep = 0;
            this.gandlem.setShoot(true);
        }

        public void stop() {
            this.lastSeen = 0;
            this.gandlem.setShoot(false);
        }

        public void tick() {
            int i;
            --this.attackTime;
            LivingEntity livingentity = this.gandlem.getTarget();
            int n = i = this.gandlem.isFullCharge() ? 5 : 0;
            if (livingentity != null) {
                boolean flag = this.gandlem.getSensing().hasLineOfSight((Entity)livingentity);
                this.lastSeen = flag ? 0 : ++this.lastSeen;
                double d0 = this.gandlem.distanceToSqr((Entity)livingentity);
                if (d0 < 8.5) {
                    if (!flag) {
                        return;
                    }
                    this.attackStep = 0;
                    if (this.gandlem.isShoot()) {
                        this.gandlem.setShoot(false);
                    }
                    if (d0 < 5.0 + (double)this.gandlem.getBbWidth() && this.attackTime <= 0) {
                        this.attackTime = 20;
                        Level level = this.gandlem.level();
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            this.gandlem.doHurtTarget(serverLevel, (Entity)livingentity);
                        }
                    }
                    this.gandlem.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                    this.gandlem.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                } else if (d0 < this.getFollowDistance() * this.getFollowDistance() * 0.75 && flag) {
                    if (!this.gandlem.isShoot()) {
                        this.gandlem.setShoot(true);
                    }
                    if (this.attackTime <= 0) {
                        ++this.attackStep;
                        if (this.attackStep == 1) {
                            this.attackTime = 30 + i;
                        } else if (this.attackStep <= 4) {
                            this.attackTime = 8;
                        } else {
                            this.attackTime = 30 + i;
                            this.attackStep = 0;
                        }
                        if (this.attackStep > 1) {
                            double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
                            this.gandlem.level().broadcastEntityEvent((Entity)this.gandlem, (byte)5);
                            this.gandlem.performRangedAttack(livingentity, this.attackTime);
                        }
                    }
                    if (d0 < this.getFollowDistance() * this.getFollowDistance() * 0.5 && this.lastSeen <= 20) {
                        ++this.strafingTime;
                        this.gandlem.getNavigation().stop();
                    } else {
                        this.strafingTime = -1;
                        this.gandlem.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), 1.0);
                    }
                    if (this.strafingTime >= 20) {
                        if ((double)this.gandlem.getRandom().nextFloat() < 0.3) {
                            boolean bl = this.strafingClockwise = !this.strafingClockwise;
                        }
                        if ((double)this.gandlem.getRandom().nextFloat() < 0.3) {
                            this.strafingBackwards = !this.strafingBackwards;
                        }
                        this.strafingTime = 0;
                    }
                    if (this.strafingTime > -1) {
                        if (d0 > this.getFollowDistance() * this.getFollowDistance() * (double)0.4f) {
                            this.strafingBackwards = false;
                        } else if (d0 < this.getFollowDistance() * this.getFollowDistance() * 0.25) {
                            this.strafingBackwards = true;
                        }
                        this.gandlem.getMoveControl().strafe(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                        this.gandlem.lookAt((Entity)livingentity, 10.0f, 10.0f);
                    } else {
                        this.gandlem.getLookControl().setLookAt((Entity)livingentity, 10.0f, 10.0f);
                    }
                } else if (this.lastSeen < 200 && d0 > this.getFollowDistance() * this.getFollowDistance() || d0 <= this.getFollowDistance() * this.getFollowDistance()) {
                    this.gandlem.getNavigation().moveTo(livingentity.getX(), livingentity.getY(), livingentity.getZ(), (double)1.1f);
                }
                super.tick();
            }
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        private double getFollowDistance() {
            return this.gandlem.getAttributeValue(Attributes.FOLLOW_RANGE);
        }
    }
}

