/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.fluid_type;

import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidType;

public class SoymilkFluidType
extends FluidType {
    public SoymilkFluidType(FluidType.Properties properties) {
        super(properties);
    }

    public boolean move(FluidState state, LivingEntity entity, Vec3 movementVector, double gravity) {
        boolean flag = entity.getDeltaMovement().y <= 0.0;
        double d8 = entity.getY();
        float f = entity.isSprinting() ? 0.9f : 0.8f;
        float f1 = 0.3f;
        float f2 = (float)entity.getAttributeValue(Attributes.WATER_MOVEMENT_EFFICIENCY);
        if (!entity.onGround()) {
            f2 *= 0.5f;
        }
        if (f2 > 0.0f) {
            f += (0.54600006f - f) * f2;
            f1 += (entity.getSpeed() - f1) * f2;
        }
        if (entity.hasEffect(MobEffects.DOLPHINS_GRACE)) {
            f = 0.96f;
        }
        entity.moveRelative(f1 *= (float)entity.getAttributeValue(NeoForgeMod.SWIM_SPEED), movementVector);
        entity.move(MoverType.SELF, entity.getDeltaMovement());
        Vec3 vec3 = entity.getDeltaMovement();
        if (entity.horizontalCollision && entity.onClimbable()) {
            vec3 = new Vec3(vec3.x, 0.2, vec3.z);
        }
        vec3 = vec3.multiply((double)f, (double)0.8f, (double)f);
        entity.setDeltaMovement(entity.getFluidFallingAdjustedMovement(gravity, flag, vec3));
        return true;
    }
}

