/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.inventory;

import baguchi.tofucraft.blockentity.TofuPotBlockEntity;
import baguchi.tofucraft.inventory.slot.TofuPotResultSlot;
import baguchi.tofucraft.recipe.TofuPotRecipe;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuMenus;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.recipebook.ServerPlaceRecipe;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TofuPotMenu
extends RecipeBookMenu {
    public final TofuPotBlockEntity blockEntity;
    public final Container inventory;
    private final ContainerData cookingPotData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;
    private boolean placingRecipe;

    public TofuPotMenu(int windowId, Inventory playerInventory, FriendlyByteBuf data) {
        this(windowId, playerInventory, TofuPotMenu.getTileEntity(playerInventory, data), (ContainerData)new SimpleContainerData(2));
    }

    public TofuPotMenu(int windowId, Inventory playerInventory, TofuPotBlockEntity blockEntity, ContainerData cookingPotDataIn) {
        super(TofuMenus.TOFU_POT.get(), windowId);
        int column;
        this.blockEntity = blockEntity;
        this.inventory = blockEntity;
        this.cookingPotData = cookingPotDataIn;
        this.level = playerInventory.player.level();
        this.canInteractWithCallable = ContainerLevelAccess.create((Level)blockEntity.getLevel(), (BlockPos)blockEntity.getBlockPos());
        int startX = 8;
        int startY = 18;
        int inputStartX = 44;
        int inputStartY = 8;
        int borderSlotSize = 18;
        for (int row = 0; row < 4; ++row) {
            for (column = 0; column < 3; ++column) {
                this.addSlot(new Slot(this.inventory, row * 3 + column, inputStartX + column * borderSlotSize, inputStartY + row * borderSlotSize));
            }
        }
        this.addSlot(new TofuPotResultSlot(this, playerInventory.player, this.inventory, 13, 130, 37){

            @Override
            public boolean mayPlace(ItemStack stack) {
                return false;
            }
        });
        int startPlayerInvY = 96;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.addSlot(new Slot((Container)playerInventory, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.addSlot(new Slot((Container)playerInventory, column, startX + column * borderSlotSize, 154));
        }
        this.addDataSlots(cookingPotDataIn);
    }

    private static TofuPotBlockEntity getTileEntity(Inventory playerInventory, FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.player.level().getBlockEntity(data.readBlockPos());
        if (tileAtPos instanceof TofuPotBlockEntity) {
            return (TofuPotBlockEntity)tileAtPos;
        }
        throw new IllegalStateException("Tile entity is not correct! " + String.valueOf(tileAtPos));
    }

    public boolean stillValid(Player playerIn) {
        return TofuPotMenu.stillValid((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)((Block)TofuBlocks.TOFU_POT.get()));
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        int indexMealDisplay = 6;
        int indexContainerInput = 7;
        int indexOutput = 12;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            slotStackCopy = slotStack.copy();
            if (index == indexOutput ? !this.moveItemStackTo(slotStack, startPlayerInv, endPlayerInv, true) : !this.moveItemStackTo(slotStack, startPlayerInv, endPlayerInv, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (slotStack.getCount() == slotStackCopy.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public int getCookProgressionScaled() {
        int i = this.cookingPotData.get(0);
        int j = this.cookingPotData.get(1);
        return j != 0 && i != 0 ? i * 24 / j : 0;
    }

    public boolean isHeated() {
        return this.blockEntity.isHeated();
    }

    public void slotsChanged(Container p_39366_) {
        if (!this.placingRecipe) {
            // empty if block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeBookMenu.PostPlaceAction handlePlacement(boolean p_361638_, boolean p_361841_, RecipeHolder<?> p_364981_, ServerLevel p_379885_, Inventory p_361078_) {
        RecipeBookMenu.PostPlaceAction recipebookmenu$postplaceaction;
        RecipeHolder<?> recipeholder = p_364981_;
        this.beginPlacingRecipe();
        try {
            List<Slot> list = this.getInputGridSlots();
            recipebookmenu$postplaceaction = ServerPlaceRecipe.placeRecipe((ServerPlaceRecipe.CraftingMenuAccess)new ServerPlaceRecipe.CraftingMenuAccess<TofuPotRecipe>(){

                public void fillCraftSlotsStackedContents(StackedItemContents p_363395_) {
                    TofuPotMenu.this.fillCraftSlotsStackedContents(p_363395_);
                }

                public void clearCraftingContent() {
                    for (int i = 0; i < 12; ++i) {
                        TofuPotMenu.this.inventory.setItem(i, ItemStack.EMPTY);
                    }
                }

                public boolean recipeMatches(RecipeHolder<TofuPotRecipe> p_365206_) {
                    return ((TofuPotRecipe)p_365206_.value()).matches((RecipeInput)CraftingInput.ofPositioned((int)4, (int)3, TofuPotMenu.this.blockEntity.getInventory()).input(), TofuPotMenu.this.level);
                }
            }, (int)4, (int)3, list, list, (Inventory)p_361078_, recipeholder, (boolean)p_361638_, (boolean)p_361841_);
        }
        finally {
            this.finishPlacingRecipe(p_379885_, p_364981_);
        }
        return recipebookmenu$postplaceaction;
    }

    public void beginPlacingRecipe() {
        this.placingRecipe = true;
    }

    public void finishPlacingRecipe(ServerLevel p_380098_, RecipeHolder<TofuPotRecipe> p_345915_) {
        this.placingRecipe = false;
    }

    public void fillCraftSlotsStackedContents(StackedItemContents p_363436_) {
        this.blockEntity.fillStackedContents(p_363436_);
    }

    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.valueOf((String)"TOFUCRAFT_COOKING");
    }

    public Slot getResultSlot() {
        return (Slot)this.slots.get(12);
    }

    public List<Slot> getInputGridSlots() {
        return this.slots.subList(0, 12);
    }
}

