/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.item.tool;

import baguchi.tofucraft.entity.ItemInteractable;
import baguchi.tofucraft.entity.TofuPig;
import baguchi.tofucraft.registry.TofuAdvancements;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ZundaMushroomOnAStickItem<T extends Entity>
extends Item {
    private final Supplier<EntityType<T>> canInteractWith;
    private final int consumeItemDamage;

    public ZundaMushroomOnAStickItem(Item.Properties p_41383_, Supplier<EntityType<T>> canInteractWith, int consumeItemDamage) {
        super(p_41383_);
        this.canInteractWith = canInteractWith;
        this.consumeItemDamage = consumeItemDamage;
    }

    public InteractionResult use(Level p_41314_, Player p_41315_, InteractionHand p_41316_) {
        ItemStack itemstack = p_41315_.getItemInHand(p_41316_);
        if (p_41314_.isClientSide) {
            return InteractionResult.PASS;
        }
        Entity entity = p_41315_.getVehicle();
        if (p_41315_.isPassenger() && entity instanceof ItemInteractable && entity.getType() == this.canInteractWith.get() && entity instanceof TofuPig) {
            TofuPig pig = (TofuPig)entity;
            ItemInteractable itemInteractable = (ItemInteractable)entity;
            if (pig.getTofuPigType() == TofuPig.TofuPigType.ZUNDA && itemInteractable.canHeal()) {
                p_41315_.getCooldowns().addCooldown(itemstack, 200);
                itemstack.hurtAndBreak(this.consumeItemDamage, (LivingEntity)p_41315_, LivingEntity.getSlotForHand((InteractionHand)p_41316_));
                if (p_41315_ instanceof ServerPlayer) {
                    TofuAdvancements.TOFUPIG_POP.get().trigger((ServerPlayer)p_41315_);
                }
                if (itemstack.isEmpty()) {
                    EquipmentSlot equipmentslot = LivingEntity.getSlotForHand((InteractionHand)p_41316_);
                    ItemStack itemstack1 = itemstack.hurtAndConvertOnBreak(this.consumeItemDamage, (ItemLike)Items.FISHING_ROD, (LivingEntity)p_41315_, equipmentslot);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.SUCCESS;
            }
        }
        p_41315_.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResult.PASS;
    }
}

