/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.mixin;

import baguchi.tofucraft.registry.TofuDimensions;
import baguchi.tofucraft.registry.TofuItems;
import baguchi.tofucraft.registry.TofuLootTables;
import baguchi.tofucraft.registry.TofuParticleTypes;
import baguchi.tofucraft.registry.TofuTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Projectile {
    @Shadow
    private int nibble;
    @Shadow
    @Final
    private int luck;
    @Shadow
    private int timeUntilHooked;
    @Shadow
    private int timeUntilLured;
    @Shadow
    private float fishAngle;

    public FishingHookMixin(EntityType<? extends Projectile> entityType, Level world) {
        super(entityType, world);
    }

    @Redirect(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/TagKey;)Z", ordinal=1))
    private boolean tofucraftreload$bobberFloat(FluidState instance, TagKey<Fluid> p_205071_) {
        return instance.is(p_205071_) || instance.is(TofuTags.Fluids.SOYMILK);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/TagKey;)Z", ordinal=0))
    private boolean tofucraftreload$CheckHeight(FluidState instance, TagKey<Fluid> p_205071_) {
        if (instance.is(TofuTags.Fluids.SOYMILK)) {
            return true;
        }
        return instance.is(p_205071_);
    }

    @Inject(method={"retrieve(Lnet/minecraft/world/item/ItemStack;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void tofucraftreload$dimensionFishingLoot(ItemStack p_37157_, CallbackInfoReturnable<Integer> cir) {
        Player player = this.getPlayerOwner();
        FishingHook fishingHook = (FishingHook)this;
        if (!this.level().isClientSide && player != null && !this.shouldStopFishing(player)) {
            ItemFishedEvent event = null;
            if (this.level() != null && this.level().dimension().equals(TofuDimensions.tofu_world) && this.nibble > 0) {
                LootParams lootparams = new LootParams.Builder((ServerLevel)this.level()).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.TOOL, (Object)p_37157_).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)this.getOwner()).withLuck((float)this.luck + player.getLuck()).create(LootContextParamSets.FISHING);
                LootTable loottable = this.level().getServer().reloadableRegistries().getLootTable(TofuLootTables.TOFU_WORLD_FISHING_LOOT_TABLE);
                ObjectArrayList list = loottable.getRandomItems(lootparams);
                event = new ItemFishedEvent((List)list, this.onGround() ? 2 : 1, fishingHook);
                NeoForge.EVENT_BUS.post((Event)event);
                if (event.isCanceled()) {
                    this.discard();
                    cir.setReturnValue((Object)event.getRodDamage());
                }
                CriteriaTriggers.FISHING_ROD_HOOKED.trigger((ServerPlayer)player, p_37157_, fishingHook, (Collection)list);
                for (ItemStack itemstack : list) {
                    ItemEntity itementity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemstack);
                    double d0 = player.getX() - this.getX();
                    double d1 = player.getY() - this.getY();
                    double d2 = player.getZ() - this.getZ();
                    double d3 = 0.1;
                    itementity.setDeltaMovement(d0 * 0.1, d1 * 0.1 + Math.sqrt(Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2)) * 0.08, d2 * 0.1);
                    this.level().addFreshEntity((Entity)itementity);
                    player.level().addFreshEntity((Entity)new ExperienceOrb(player.level(), player.getX(), player.getY() + 0.5, player.getZ() + 0.5, this.random.nextInt(6) + 1));
                    if (!itemstack.is(ItemTags.FISHES) && !itemstack.is((Item)TofuItems.RAW_TOFU_FISH.get())) continue;
                    player.awardStat(Stats.FISH_CAUGHT, 1);
                }
                int i = 1;
                this.discard();
                cir.setReturnValue((Object)(event == null ? i : event.getRodDamage()));
            }
        }
    }

    @Shadow
    private boolean shouldStopFishing(Player player) {
        return false;
    }

    @Shadow
    public Player getPlayerOwner() {
        return null;
    }

    @Inject(method={"catchingFish"}, at={@At(value="HEAD")}, cancellable=true)
    private void tofucraftreload$showSplash(BlockPos blockPos, CallbackInfo callbackInfo) {
        ServerLevel serverlevel = (ServerLevel)this.level();
        int i = 1;
        BlockPos blockpos = blockPos.above();
        if (this.random.nextFloat() < 0.25f && this.level().isRainingAt(blockpos)) {
            ++i;
        }
        if (this.random.nextFloat() < 0.5f && !this.level().canSeeSky(blockpos)) {
            --i;
        }
        if (this.nibble <= 0) {
            if (this.timeUntilHooked > 0) {
                this.timeUntilHooked -= i;
                if (this.timeUntilHooked > 0) {
                    double d2;
                    double d1;
                    this.fishAngle += (float)this.random.triangle(0.0, 9.188);
                    float f = this.fishAngle * ((float)Math.PI / 180);
                    float f1 = Mth.sin((float)f);
                    float f2 = Mth.cos((float)f);
                    double d0 = this.getX() + (double)(f1 * (float)this.timeUntilHooked * 0.1f);
                    FluidState fluidstate = serverlevel.getFluidState(BlockPos.containing((double)d0, (double)((d1 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d2 = this.getZ() + (double)(f2 * (float)this.timeUntilHooked * 0.1f))));
                    if (fluidstate.is(TofuTags.Fluids.SOYMILK)) {
                        if (this.random.nextFloat() < 0.15f) {
                            serverlevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, d0, d1 - (double)0.1f, d2, 1, (double)f1, 0.1, (double)f2, 0.0);
                        }
                        float f3 = f1 * 0.04f;
                        float f4 = f2 * 0.04f;
                        serverlevel.sendParticles((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), d0, d1, d2, 0, (double)f4, 0.01, (double)(-f3), 1.0);
                        serverlevel.sendParticles((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), d0, d1, d2, 0, (double)(-f4), 0.01, (double)f3, 1.0);
                    }
                } else {
                    this.playSound(SoundEvents.FISHING_BOBBER_SPLASH, 0.25f, 1.0f + (this.random.nextFloat() - this.random.nextFloat()) * 0.4f);
                    double d3 = this.getY() + 0.5;
                    serverlevel.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                    serverlevel.sendParticles((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), this.getX(), d3, this.getZ(), (int)(1.0f + this.getBbWidth() * 20.0f), (double)this.getBbWidth(), 0.0, (double)this.getBbWidth(), (double)0.2f);
                    this.nibble = Mth.nextInt((RandomSource)this.random, (int)20, (int)40);
                }
            } else if (this.timeUntilLured > 0) {
                float f5 = 0.15f;
                if (this.timeUntilLured < 20) {
                    f5 += (float)(20 - this.timeUntilLured) * 0.05f;
                } else if (this.timeUntilLured < 40) {
                    f5 += (float)(40 - this.timeUntilLured) * 0.02f;
                } else if (this.timeUntilLured < 60) {
                    f5 += (float)(60 - this.timeUntilLured) * 0.01f;
                }
                if (this.random.nextFloat() < f5) {
                    double d6;
                    double d5;
                    float f6 = Mth.nextFloat((RandomSource)this.random, (float)0.0f, (float)360.0f) * ((float)Math.PI / 180);
                    float f7 = Mth.nextFloat((RandomSource)this.random, (float)25.0f, (float)60.0f);
                    double d4 = this.getX() + (double)(Mth.sin((float)f6) * f7) * 0.1;
                    FluidState fluidstate = serverlevel.getFluidState(BlockPos.containing((double)d4, (double)((d5 = (double)((float)Mth.floor((double)this.getY()) + 1.0f)) - 1.0), (double)(d6 = this.getZ() + (double)(Mth.cos((float)f6) * f7) * 0.1)));
                    if (fluidstate.is(TofuTags.Fluids.SOYMILK)) {
                        serverlevel.sendParticles((ParticleOptions)TofuParticleTypes.SOYMILK_SPLASH.get(), d4, d5, d6, 2 + this.random.nextInt(2), (double)0.1f, 0.0, (double)0.1f, 0.0);
                    }
                }
            }
        }
    }

    @Redirect(method={"getOpenWaterTypeForBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/TagKey;)Z", ordinal=0))
    private boolean getOpenWaterTypeForBlock(FluidState instance, TagKey<Fluid> p_205071_) {
        if (instance.is(TofuTags.Fluids.SOYMILK)) {
            return true;
        }
        return instance.is(p_205071_);
    }
}

