/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.recipe;

import baguchi.tofucraft.recipe.TFCraftingCategory;
import baguchi.tofucraft.recipe.TFCraftingRecipe;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuRecipes;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.RecipeMatcher;

public class TFShapelessRecipe
implements TFCraftingRecipe {
    private final String group;
    private final TFCraftingCategory category;
    private final ItemStack result;
    private final List<Ingredient> ingredients;
    private final int tfNeed;
    private final boolean isSimple;
    @Nullable
    private PlacementInfo placementInfo;

    public TFShapelessRecipe(String group, TFCraftingCategory category, ItemStack result, List<Ingredient> ingredients, int tfNeed) {
        this.group = group;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.tfNeed = tfNeed;
    }

    public RecipeSerializer<? extends Recipe<CraftingInput>> getSerializer() {
        return TofuRecipes.RECIPE_TF_CRAFT_SHAPELESS.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.ingredients.stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(TofuBlocks.TF_CRAFTING_TABLE.asItem())));
    }

    public String getGroup() {
        return this.group;
    }

    @Override
    public TFCraftingCategory category() {
        return this.category;
    }

    @Override
    public int getNeedTF() {
        return this.tfNeed;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : input.items()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? this.ingredients.getFirst().test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @Override
    public ItemStack getResult() {
        return this.result.copy();
    }

    @Override
    @VisibleForTesting
    public List<Optional<Ingredient>> getIngredients() {
        return this.ingredients.stream().map(Optional::of).toList();
    }

    public static class Serializer
    implements RecipeSerializer<TFShapelessRecipe> {
        private static final MapCodec<TFShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)TFCraftingCategory.CODEC.fieldOf("category").orElse((Object)TFCraftingCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, 12)).fieldOf("ingredients").forGetter(p_360071_ -> p_360071_.ingredients), (App)Codec.INT.fieldOf("cook_time").orElse((Object)300).forGetter(potShapelessRecipe -> potShapelessRecipe.tfNeed)).apply((Applicative)p_340779_, (group1, category1, result1, ingredients1, tfNeed) -> new TFShapelessRecipe((String)group1, (TFCraftingCategory)((Object)((Object)category1)), (ItemStack)result1, (List<Ingredient>)ingredients1, (int)tfNeed)));
        public static final StreamCodec<RegistryFriendlyByteBuf, TFShapelessRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p_360074_ -> p_360074_.group, TFCraftingCategory.STREAM_CODEC, p_360073_ -> p_360073_.category, (StreamCodec)ItemStack.STREAM_CODEC, p_360070_ -> p_360070_.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), p_360069_ -> p_360069_.ingredients, (StreamCodec)ByteBufCodecs.INT, p_360069_ -> p_360069_.tfNeed, TFShapelessRecipe::new);

        public MapCodec<TFShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TFShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

