/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.recipe;

import baguchi.tofucraft.recipe.TofuPotCategory;
import baguchi.tofucraft.recipe.TofuPotRecipe;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuRecipes;
import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.PlacementInfo;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.util.RecipeMatcher;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class TofuPotShapelessRecipe
implements TofuPotRecipe {
    final String group;
    final TofuPotCategory category;
    final ItemStack result;
    final List<Ingredient> ingredients;
    final Optional<SizedFluidIngredient> ingredientFluid;
    private final int cookTime;
    private final float experience;
    private final boolean isSimple;
    @Nullable
    private PlacementInfo placementInfo;

    public TofuPotShapelessRecipe(String p_249640_, TofuPotCategory category, ItemStack result, List<Ingredient> ingredients, Optional<SizedFluidIngredient> ingredientFluid, int cookTime, float experience) {
        this.group = p_249640_;
        this.category = category;
        this.result = result;
        this.ingredients = ingredients;
        this.isSimple = ingredients.stream().allMatch(Ingredient::isSimple);
        this.ingredientFluid = ingredientFluid;
        this.cookTime = cookTime;
        this.experience = experience;
    }

    public RecipeSerializer<? extends Recipe<CraftingInput>> getSerializer() {
        return TofuRecipes.RECIPE_TOFU_POT_SHAPELESS.get();
    }

    public PlacementInfo placementInfo() {
        if (this.placementInfo == null) {
            this.placementInfo = PlacementInfo.create(this.ingredients);
        }
        return this.placementInfo;
    }

    public List<RecipeDisplay> display() {
        return List.of(new ShapelessCraftingRecipeDisplay(this.ingredients.stream().map(Ingredient::display).toList(), (SlotDisplay)new SlotDisplay.ItemStackSlotDisplay(this.result), (SlotDisplay)new SlotDisplay.ItemSlotDisplay(((Block)TofuBlocks.TOFU_POT.get()).asItem())));
    }

    @Override
    public TofuPotCategory category() {
        return this.category;
    }

    @Override
    public int getCookTime() {
        return this.cookTime;
    }

    @Override
    public Optional<SizedFluidIngredient> fluidIngredient() {
        return this.ingredientFluid;
    }

    @Override
    public float getExperience() {
        return this.experience;
    }

    public boolean matches(CraftingInput input, Level level) {
        if (input.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        if (!this.isSimple) {
            ArrayList<ItemStack> nonEmptyItems = new ArrayList<ItemStack>(input.ingredientCount());
            for (ItemStack item : input.items()) {
                if (item.isEmpty()) continue;
                nonEmptyItems.add(item);
            }
            return RecipeMatcher.findMatches(nonEmptyItems, this.ingredients) != null;
        }
        return input.size() == 1 && this.ingredients.size() == 1 ? this.ingredients.getFirst().test(input.getItem(0)) : input.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        return this.result.copy();
    }

    @Override
    public ItemStack getResult() {
        return this.result.copy();
    }

    @Override
    @VisibleForTesting
    public List<Optional<Ingredient>> getIngredients() {
        return this.ingredients.stream().map(Optional::of).toList();
    }

    public static class Serializer
    implements RecipeSerializer<TofuPotShapelessRecipe> {
        public static final StreamCodec<RegistryFriendlyByteBuf, Optional<SizedFluidIngredient>> OPTIONAL_STREAM_CODEC = ByteBufCodecs.optional((StreamCodec)SizedFluidIngredient.STREAM_CODEC);
        private static final MapCodec<TofuPotShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(p_301127_ -> p_301127_.group), (App)TofuPotCategory.CODEC.fieldOf("category").orElse((Object)TofuPotCategory.MISC).forGetter(p_301133_ -> p_301133_.category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(p_301142_ -> p_301142_.result), (App)Codec.lazyInitialized(() -> Ingredient.CODEC.listOf(1, 12)).fieldOf("ingredients").forGetter(p_360071_ -> p_360071_.ingredients), (App)SizedFluidIngredient.CODEC.optionalFieldOf("fluid").forGetter(potShapelessRecipe -> potShapelessRecipe.ingredientFluid), (App)Codec.INT.fieldOf("cook_time").orElse((Object)300).forGetter(potShapelessRecipe -> potShapelessRecipe.cookTime), (App)Codec.FLOAT.fieldOf("experience").orElse((Object)Float.valueOf(0.1f)).forGetter(potShapelessRecipe -> Float.valueOf(potShapelessRecipe.experience))).apply((Applicative)p_340779_, (group1, category1, result1, ingredients1, fluidIngredient, cookTime, experience) -> new TofuPotShapelessRecipe((String)group1, (TofuPotCategory)((Object)((Object)category1)), (ItemStack)result1, (List<Ingredient>)ingredients1, (Optional<SizedFluidIngredient>)fluidIngredient, (int)cookTime, experience.floatValue())));
        public static final StreamCodec<RegistryFriendlyByteBuf, TofuPotShapelessRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, p_360074_ -> p_360074_.group, TofuPotCategory.STREAM_CODEC, p_360073_ -> p_360073_.category, (StreamCodec)ItemStack.STREAM_CODEC, p_360070_ -> p_360070_.result, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), p_360069_ -> p_360069_.ingredients, OPTIONAL_STREAM_CODEC, p_360069_ -> p_360069_.ingredientFluid, (StreamCodec)ByteBufCodecs.INT, p_360069_ -> p_360069_.cookTime, (StreamCodec)ByteBufCodecs.FLOAT, p_360069_ -> Float.valueOf(p_360069_.experience), TofuPotShapelessRecipe::new);

        public MapCodec<TofuPotShapelessRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, TofuPotShapelessRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

