/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class TofuData
extends SavedData {
    public static final Codec<TofuData> CODEC = RecordCodecBuilder.create(p_400930_ -> p_400930_.group((App)Codec.INT.fieldOf("traveler_spawn_delay").forGetter(p_400933_ -> p_400933_.travelerSpawnDelay), (App)Codec.FLOAT.fieldOf("traveler_spawn_chance").forGetter(p_400933_ -> Float.valueOf(p_400933_.travelerSpawnChance)), (App)BoundingBox.CODEC.listOf().fieldOf("beated_bounding_box").forGetter(p_400933_ -> p_400933_.beatenDungeons)).apply((Applicative)p_400930_, TofuData::new));
    private static final String IDENTIFIER = "tofucraft_world_data";
    public static final SavedDataType<TofuData> TYPE = new SavedDataType("tofucraft_world_data", TofuData::new, CODEC);
    private int travelerSpawnDelay;
    private float travelerSpawnChance;
    private static Map<Level, TofuData> dataMap = new HashMap<Level, TofuData>();
    public List<BoundingBox> beatenDungeons = new ArrayList<BoundingBox>();

    public TofuData() {
        this(6000, 0.1f, Lists.newArrayList());
    }

    public TofuData(int travelerSpawnDelay, float travelerSpawnChance, List<BoundingBox> beatenDungeons) {
        this.travelerSpawnDelay = travelerSpawnDelay;
        this.travelerSpawnChance = travelerSpawnChance;
        this.beatenDungeons = beatenDungeons;
    }

    public static TofuData get(Level world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            ServerLevel overworld = world.getServer().getLevel(world.dimension());
            TofuData fromMap = dataMap.get(overworld);
            if (fromMap == null) {
                DimensionDataStorage storage = overworld.getDataStorage();
                TofuData data = (TofuData)storage.computeIfAbsent(TYPE);
                if (data != null) {
                    data.setDirty();
                }
                dataMap.put(world, data);
                return data;
            }
            return fromMap;
        }
        return null;
    }

    public int getTravelerSpawnDelay() {
        return this.travelerSpawnDelay;
    }

    public void setTravelerSpawnDelay(int delay) {
        this.travelerSpawnDelay = delay;
    }

    public float getTravelerSpawnChance() {
        return this.travelerSpawnChance;
    }

    public void setTravelerSpawnChance(float chance) {
        this.travelerSpawnChance = chance;
    }

    public void addBeatenDungeons(BoundingBox box) {
        this.beatenDungeons.add(box);
        this.setDirty();
    }

    public List<BoundingBox> getBeatenDungeons() {
        return this.beatenDungeons;
    }
}

