/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world;

import baguchi.tofucraft.TofuConfig;
import baguchi.tofucraft.entity.TravelerTofunian;
import baguchi.tofucraft.registry.TofuEntityTypes;
import baguchi.tofucraft.world.TofuData;
import java.util.Iterator;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;

public class TravelerTofunianSpawner {
    private final Random random = new Random();
    private final ServerLevel world;
    private int timer;
    private int delay;
    private float chance;

    public TravelerTofunianSpawner(ServerLevel level) {
        this.world = level;
        this.timer = 1200;
        TofuData worldinfo = TofuData.get((Level)level);
        this.delay = worldinfo.getTravelerSpawnDelay();
        this.chance = worldinfo.getTravelerSpawnChance();
        if (this.delay == 0 && this.chance == 0.0f) {
            this.delay = 24000;
            worldinfo.setTravelerSpawnDelay(this.delay);
            this.chance = 0.3f;
            worldinfo.setTravelerSpawnChance(this.chance);
        }
    }

    public void tick() {
        if (((Boolean)TofuConfig.COMMON.travelerTofunianSpawn.get()).booleanValue() && --this.timer <= 0) {
            this.timer = 1200;
            this.delay -= 1200;
            if (this.delay < 0) {
                this.delay = 0;
            }
            TofuData worldinfo = TofuData.get((Level)this.world);
            worldinfo.setTravelerSpawnDelay(this.delay);
            if (this.delay <= 0) {
                this.delay = 24000;
                if (this.world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && this.world.getGameRules().getBoolean(GameRules.RULE_DO_TRADER_SPAWNING)) {
                    float prevChance = this.chance;
                    this.chance = Mth.clamp((float)(this.chance + 0.1f), (float)0.0f, (float)1.0f);
                    worldinfo.setTravelerSpawnChance(this.chance);
                    if (this.random.nextFloat() <= prevChance && this.attemptSpawnWanderingTraveler()) {
                        this.chance = 0.1f;
                    }
                }
            }
        }
    }

    private boolean attemptSpawnWanderingTraveler() {
        TofuData worldinfo = TofuData.get((Level)this.world);
        ServerPlayer playerentity = this.world.getRandomPlayer();
        if (playerentity == null) {
            return true;
        }
        if (this.random.nextInt(5) != 0 || this.world.dimension() != Level.OVERWORLD) {
            return false;
        }
        BlockPos blockpos = BlockPos.containing((Position)playerentity.position());
        PoiManager poimanager = this.world.getPoiManager();
        Optional optional = poimanager.find(p_219713_ -> p_219713_.is(PoiTypes.MEETING), p_219711_ -> true, blockpos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = optional.orElse(blockpos);
        BlockPos blockpos2 = this.findSpawnLocationNear(blockpos1, 84);
        if (blockpos2 != null && this.func_226559_a_(blockpos2) && blockpos2.distSqr((Vec3i)blockpos) > 225.0) {
            if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)this.world, blockpos2)) {
                if (this.world.getBiome(blockpos2).is(BiomeTags.WITHOUT_WANDERING_TRADER_SPAWNS)) {
                    return false;
                }
                TravelerTofunian tofunian = (TravelerTofunian)TofuEntityTypes.TRAVELER_TOFUNIAN.get().spawn(this.world, blockpos2, EntitySpawnReason.EVENT);
                if (tofunian != null) {
                    tofunian.setDespawnDelay(48000);
                    tofunian.setWanderTarget(blockpos1);
                    tofunian.restrictTo(blockpos1, 22);
                    return true;
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    private BlockPos findSpawnLocationNear(BlockPos center, int xzDistance) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            FluidState fluidState;
            BlockState blockstate;
            int k;
            int l;
            int j = center.getX() + this.random.nextInt(xzDistance * 2) - xzDistance;
            BlockPos blockpos1 = new BlockPos(j, l = this.world.getHeight(Heightmap.Types.WORLD_SURFACE, j, k = center.getZ() + this.random.nextInt(xzDistance * 2) - xzDistance), k);
            if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)this.world, (BlockPos)blockpos1, (BlockState)(blockstate = this.world.getBlockState(blockpos1)), (FluidState)(fluidState = this.world.getFluidState(blockpos1)), TofuEntityTypes.TRAVELER_TOFUNIAN.get())) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean func_226559_a_(BlockPos p_226559_1_) {
        BlockPos blockpos;
        Iterator var2 = BlockPos.betweenClosed((BlockPos)p_226559_1_, (BlockPos)p_226559_1_.offset(1, 2, 1)).iterator();
        do {
            if (var2.hasNext()) continue;
            return true;
        } while (this.world.getBlockState(blockpos = (BlockPos)var2.next()).getBlockSupportShape((BlockGetter)this.world, blockpos).isEmpty() && this.world.getFluidState(blockpos).isEmpty());
        return false;
    }

    private boolean hasEnoughSpace(BlockGetter level, BlockPos pos) {
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)pos, (BlockPos)pos.offset(1, 2, 1))) {
            if (level.getBlockState(blockpos).getCollisionShape(level, blockpos).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

