/*
 * Decompiled with CFR 0.152.
 */
package baguchi.tofucraft.world.gen.features;

import baguchi.tofucraft.TofuCraftReload;
import baguchi.tofucraft.registry.TofuBlocks;
import baguchi.tofucraft.registry.TofuFeatures;
import baguchi.tofucraft.registry.TofuTags;
import com.google.common.collect.ImmutableList;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.BlockStateConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.DeltaFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class TofuWorldFeatures {
    public static final RuleTest TOFU_ORE_REPLACEABLES = new BlockMatchTest((Block)TofuBlocks.TOFU_TERRAIN.get());
    public static final RuleTest TOFUSLATE_ORE_REPLACEABLES = new BlockMatchTest((Block)TofuBlocks.TOFUSLATE.get());
    public static final RuleTest TOFUISHI_ORE_REPLACEABLES = new BlockMatchTest((Block)TofuBlocks.TOFU_TERRAIN_ISHI.get());
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_DIAMOND_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)TOFU_ORE_REPLACEABLES, (BlockState)((Block)TofuBlocks.ORE_TOFU_DIAMOND.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)TOFUSLATE_ORE_REPLACEABLES, (BlockState)((Block)TofuBlocks.TOFUSLATE_TOFU_DIAMOND_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_TOFUGEM_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)TOFU_ORE_REPLACEABLES, (BlockState)((Block)TofuBlocks.ORE_TOFUGEM.get()).defaultBlockState()), (Object)OreConfiguration.target((RuleTest)TOFUISHI_ORE_REPLACEABLES, (BlockState)((Block)TofuBlocks.ISHI_TOFUGEM_ORE.get()).defaultBlockState()));
    public static final ImmutableList<OreConfiguration.TargetBlockState> ORE_SOY_FORCE_TARGET_LIST = ImmutableList.of((Object)OreConfiguration.target((RuleTest)TOFUSLATE_ORE_REPLACEABLES, (BlockState)((Block)TofuBlocks.TOFUSLATE_SOY_FORCE_ORE.get()).defaultBlockState()));
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_KINU_TOFU = TofuWorldFeatures.registerKey("ore_kinu_tofu");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_MINCED_TOFU = TofuWorldFeatures.registerKey("ore_minced_tofu");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DIAMOND_SMALL = TofuWorldFeatures.registerKey("ore_tofu_diamond_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DIAMOND_MEDIUM = TofuWorldFeatures.registerKey("ore_tofu_diamond_medium");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DIAMOND_LARGE = TofuWorldFeatures.registerKey("ore_tofu_diamond_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_DIAMOND_BURIED = TofuWorldFeatures.registerKey("ore_tofu_diamond_buried");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_SOY_FORCE = TofuWorldFeatures.registerKey("ore_soy_force");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_TOFUGEM_SMALL = TofuWorldFeatures.registerKey("ore_tofugem_small");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ORE_TOFUGEM_LARGE = TofuWorldFeatures.registerKey("ore_tofugem_large");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_DELTA = TofuWorldFeatures.registerKey("tofu_delta");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_FLOWER = TofuWorldFeatures.registerKey("tofu_flower");
    public static final ResourceKey<ConfiguredFeature<?, ?>> LEEK = TofuWorldFeatures.registerKey("leek");
    public static final ResourceKey<ConfiguredFeature<?, ?>> BIG_LEEK = TofuWorldFeatures.registerKey("big_leek");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TOFU_BUILDING = TofuWorldFeatures.registerKey("tofu_building");
    public static final ResourceKey<ConfiguredFeature<?, ?>> ZUNDA_TOFU_MUSHROOM = TofuWorldFeatures.registerKey("zunda_tofu_mushroom");

    private static RandomPatchConfiguration grassPatch(BlockStateProvider p_195203_, int p_195204_) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)p_195204_, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(p_195203_)));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)TofuCraftReload.prefix(name));
    }

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest ruletest = new TagMatchTest(TofuTags.Blocks.TOFU_TERRAIN);
        FeatureUtils.register(context, ORE_KINU_TOFU, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)TofuBlocks.KINUTOFU.get()).defaultBlockState(), 20));
        FeatureUtils.register(context, ORE_MINCED_TOFU, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration((RuleTest)ruletest, ((Block)TofuBlocks.MINCEDTOFU.get()).defaultBlockState(), 28));
        FeatureUtils.register(context, ORE_DIAMOND_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, 4, 0.0f));
        FeatureUtils.register(context, ORE_DIAMOND_MEDIUM, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, 8, 0.25f));
        FeatureUtils.register(context, ORE_DIAMOND_LARGE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, 12, 0.5f));
        FeatureUtils.register(context, ORE_DIAMOND_BURIED, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_DIAMOND_TARGET_LIST, 8, 1.0f));
        FeatureUtils.register(context, ORE_SOY_FORCE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_SOY_FORCE_TARGET_LIST, 8, 0.0f));
        FeatureUtils.register(context, ORE_TOFUGEM_SMALL, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_TOFUGEM_TARGET_LIST, 6));
        FeatureUtils.register(context, ORE_TOFUGEM_LARGE, (Feature)Feature.ORE, (FeatureConfiguration)new OreConfiguration(ORE_TOFUGEM_TARGET_LIST, 10));
        FeatureUtils.register(context, TOFU_DELTA, (Feature)Feature.DELTA_FEATURE, (FeatureConfiguration)new DeltaFeatureConfiguration(((Block)TofuBlocks.DOUBANJIANG.get()).defaultBlockState(), ((Block)TofuBlocks.MABOU_TERRAIN.get()).defaultBlockState(), (IntProvider)UniformInt.of((int)3, (int)7), (IntProvider)UniformInt.of((int)0, (int)2)));
        FeatureUtils.register(context, TOFU_FLOWER, (Feature)Feature.FLOWER, (FeatureConfiguration)TofuWorldFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.TOFU_FLOWER.get())), 32));
        FeatureUtils.register(context, LEEK, (Feature)Feature.RANDOM_PATCH, (FeatureConfiguration)TofuWorldFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.LEEK.get())), 32));
        FeatureUtils.register(context, BIG_LEEK, TofuFeatures.BIG_LEEK.get(), (FeatureConfiguration)RandomFeatureConfiguration.NONE);
        FeatureUtils.register(context, TOFU_BUILDING, TofuFeatures.TOFU_BUILDING.get(), (FeatureConfiguration)new BlockStateConfiguration(((Block)TofuBlocks.TOFU_TERRAIN.get()).defaultBlockState()));
        FeatureUtils.register(context, ZUNDA_TOFU_MUSHROOM, (Feature)Feature.FLOWER, (FeatureConfiguration)TofuWorldFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)TofuBlocks.ZUNDATOFU_MUSHROOM.get())), 32));
    }
}

