/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IClientRegistrar;
import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.plugin.extra.config.ExtraBlacklistConfig;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class DataProvider<A extends IData, I extends A>
implements IBlockComponentProvider,
IEntityComponentProvider {
    public static final Map<IData.Type<?>, DataProvider<?, ?>> INSTANCES = new HashMap();
    private final IData.Type<A> type;
    private final StreamCodec<RegistryFriendlyByteBuf, I> codec;
    protected final ResourceLocation enabledBlockOption;
    protected final ResourceLocation enabledEntityOption;
    protected final IJsonConfig<ExtraBlacklistConfig> blacklistConfig;

    protected DataProvider(IData.Type<A> type, StreamCodec<RegistryFriendlyByteBuf, I> codec) {
        this.type = type;
        this.codec = codec;
        this.enabledBlockOption = this.createConfigKey("enabled_block");
        this.enabledEntityOption = this.createConfigKey("enabled_entity");
        ResourceLocation tagId = ResourceLocation.fromNamespaceAndPath((String)"waila", (String)("extra/" + type.id().getPath() + "_blacklist"));
        this.blacklistConfig = IJsonConfig.of(ExtraBlacklistConfig.class).file("waila/extra/" + type.id().getPath() + "_blacklist").json5().commenter(() -> ExtraBlacklistConfig.commenter(tagId)).gson(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ExtraBlacklistConfig.class, (Object)new ExtraBlacklistConfig.Adapter(tagId)).create()).build();
        this.blacklistConfig.save();
        INSTANCES.put(type, this);
    }

    public void register(ICommonRegistrar registrar, int priority) {
        registrar.featureConfig(this.enabledBlockOption, false);
        registrar.featureConfig(this.enabledEntityOption, false);
        this.registerAdditions(registrar, priority);
        registrar.externalConfig(this.createConfigKey("blacklist"), this.blacklistConfig.getPath());
        registrar.dataType(this.type, this.codec);
        registrar.blockData(new BlockDataProvider(), BlockEntity.class, 0);
        registrar.entityData(new EntityDataProvider(), Entity.class, 0);
    }

    public void register(IClientRegistrar registrar, int priority) {
        this.registerAdditions(registrar, priority);
        registrar.body(this, BlockEntity.class, priority);
        registrar.body(this, Entity.class, priority);
    }

    protected final ResourceLocation createConfigKey(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"wailax", (String)(this.type.id().getPath() + "." + path));
    }

    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
    }

    protected void registerAdditions(IClientRegistrar registrar, int priority) {
    }

    protected abstract void appendBody(ITooltip var1, I var2, IPluginConfig var3, ResourceLocation var4);

    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, ResourceLocation objectId) {
        A data = reader.get(this.type);
        if (data == null) {
            return;
        }
        this.appendBody(tooltip, data, config, objectId);
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledBlockOption)) {
            return;
        }
        if (this.blacklistConfig.get().getView().blockFilter.matches(accessor.getBlock())) {
            return;
        }
        BlockEntityType blockEntityType = ((BlockEntity)Objects.requireNonNull(accessor.getBlockEntity())).getType();
        if (this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
            return;
        }
        ResourceLocation blockEntityId = Objects.requireNonNull(BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntityType));
        this.appendBody(tooltip, accessor.getData(), config, blockEntityId);
    }

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (!config.getBoolean(this.enabledEntityOption)) {
            return;
        }
        EntityType entityType = accessor.getEntity().getType();
        if (this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
            return;
        }
        this.appendBody(tooltip, accessor.getData(), config, BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType));
    }

    private class BlockDataProvider
    implements IDataProvider<BlockEntity> {
        private BlockDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
            BlockEntity target = accessor.getTarget();
            BlockState state = target.getBlockState();
            BlockEntityType blockEntityType = target.getType();
            if (!config.getBoolean(DataProvider.this.enabledBlockOption) || DataProvider.this.blacklistConfig.get().getView().blockFilter.matches(state.getBlock()) || DataProvider.this.blacklistConfig.get().getView().blockEntityFilter.matches(blockEntityType)) {
                data.blockAll(DataProvider.this.type);
            }
        }
    }

    private class EntityDataProvider
    implements IDataProvider<Entity> {
        private EntityDataProvider() {
        }

        @Override
        public void appendData(IDataWriter data, IServerAccessor<Entity> accessor, IPluginConfig config) {
            EntityType entityType = accessor.getTarget().getType();
            if (!config.getBoolean(DataProvider.this.enabledEntityOption) || DataProvider.this.blacklistConfig.get().getView().entityFilter.matches(entityType)) {
                data.blockAll(DataProvider.this.type);
            }
        }
    }
}

