/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.gui.hud.ComponentRenderer;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.gui.hud.TooltipHandler;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.screen.YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen;
import mcp.mobius.waila.util.Log;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class InspectorScreen
extends YesIAmSureTheClientInstanceIsPresentByTheTimeIUseItScreen {
    private static final Log LOG = Log.create();
    private static final String API_COMPONENTS = "mcp.mobius.waila.api.component.";
    private static final Component TITLE = Component.m_237115_((String)"gui.waila.inspector.title");
    private static final State STATE = new State();
    private final Renderer renderer = new Renderer();
    private boolean tickSuccess = false;
    private final List<ITooltipComponent> hoveredComponent = new ArrayList<ITooltipComponent>();

    public InspectorScreen() {
        super(TITLE);
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        InspectComponent.wrap = true;
        this.tickSuccess = TooltipHandler.tick(STATE, true);
        InspectComponent.wrap = false;
    }

    public void m_7379_() {
        super.m_7379_();
        TooltipHandler.tick();
    }

    public void m_88315_(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float tickDelta) {
        super.m_88315_(ctx, mouseX, mouseY, tickDelta);
        if (!this.hoveredComponent.isEmpty()) {
            String tag;
            String clazz;
            Objects.requireNonNull(this.minecraft.f_91062_);
            int h = 9 + 2;
            ITooltipComponent component = this.hoveredComponent.get(0);
            if (component instanceof InspectComponent) {
                InspectComponent wrapper = (InspectComponent)component;
                component = wrapper.actual;
            }
            if ((clazz = component.getClass().getName()).startsWith(API_COMPONENTS)) {
                clazz = clazz.substring(API_COMPONENTS.length());
            }
            ctx.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237113_((String)clazz), 5, 5, 0xFFFFFF);
            int y = 1;
            InspectComponent wrapper = (InspectComponent)this.hoveredComponent.get(this.hoveredComponent.size() - 1);
            String string = tag = wrapper.tag == null ? null : wrapper.tag.toString();
            if (tag != null) {
                ctx.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237110_((String)"gui.waila.inspector.tag", (Object[])new Object[]{tag}), 5, 5 + h * y++, 0xFFFFFF);
            }
            String provider = wrapper.origin.instance().getClass().getName();
            ctx.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237110_((String)"gui.waila.inspector.provider", (Object[])new Object[]{provider}), 5, 5 + h * y++, 0xFFFFFF);
            String pluginId = wrapper.origin.plugin().getPluginId().toString();
            ctx.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237110_((String)"gui.waila.inspector.plugin_id", (Object[])new Object[]{pluginId}), 5, 5 + h * y++, 0xFFFFFF);
            IModInfo mod = wrapper.origin.plugin().getModInfo();
            ctx.m_280430_(this.minecraft.f_91062_, (Component)Component.m_237110_((String)"gui.waila.inspector.mod", (Object[])new Object[]{mod.getName(), mod.getId()}), 5, 5 + h * y, 0xFFFFFF);
        }
        if (this.tickSuccess) {
            this.renderer.mouseX = mouseX;
            this.renderer.mouseY = mouseY;
            this.hoveredComponent.clear();
            ComponentRenderer.set(this.renderer);
            TooltipRenderer.render(ctx, tickDelta);
            ComponentRenderer.set(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.hoveredComponent.isEmpty()) {
            String tag;
            StringBuilder sb = new StringBuilder();
            InspectComponent wrapper = (InspectComponent)this.hoveredComponent.get(this.hoveredComponent.size() - 1);
            String string = tag = wrapper.tag == null ? null : wrapper.tag.toString();
            if (tag != null) {
                sb.append("tag: ").append(tag).append("\n\t");
            }
            String provider = wrapper.origin.instance().getClass().getName();
            sb.append("provider: ").append(provider).append("\n\t");
            String pluginId = wrapper.origin.plugin().getPluginId().toString();
            sb.append("pluginId: ").append(pluginId).append("\n\t");
            IModInfo mod = wrapper.origin.plugin().getModInfo();
            sb.append("modName: ").append(mod.getName()).append("\n\t");
            sb.append("modId: ").append(mod.getId());
            LOG.info(sb.toString());
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    private class Renderer
    extends ComponentRenderer {
        int mouseX;
        int mouseY;

        private Renderer() {
        }

        @Override
        public void render(GuiGraphics ctx, ITooltipComponent component, int x, int y, int cw, int ch, float delta) {
            component.render(ctx, x, y, delta);
            float v = 0.3f;
            if (x < this.mouseX && this.mouseX < x + cw && y < this.mouseY && this.mouseY < y + ch) {
                InspectorScreen.this.hoveredComponent.add(component);
                v = 1.0f;
            }
            ComponentRenderer.Default.renderBounds(ctx, x, y, cw, ch, v);
        }
    }

    private static class State
    implements TooltipRenderer.State {
        private State() {
        }

        @Override
        public int getX() {
            return 0;
        }

        @Override
        public int getY() {
            return 0;
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return true;
        }

        @Override
        public int getFps() {
            return 0;
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return IWailaConfig.Overlay.Position.Align.Y.MIDDLE;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return IWailaConfig.Overlay.Position.Align.X.CENTER;
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return IWailaConfig.Overlay.Position.Align.Y.MIDDLE;
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }

        @Override
        public int getBackgroundAlpha() {
            return 255;
        }

        @Override
        public ITheme getTheme() {
            return WailaClient.CONFIG.get().getOverlay().getColor().getTheme();
        }
    }
}

