/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.command.CommonCommand;
import mcp.mobius.waila.forge.ForgeClientCommand;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.BuiltinThemeLoader;
import mcp.mobius.waila.gui.screen.WailaConfigScreen;
import mcp.mobius.waila.network.Packets;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.AddGuiOverlayLayersEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ForgeWailaClient
extends WailaClient {
    @SubscribeEvent
    static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Packets.initClient();
            ForgeWailaClient.registerConfigScreen();
        });
    }

    static void registerConfigScreen() {
        MinecraftForge.registerConfigScreen(WailaConfigScreen::new);
    }

    @Mod(value="wthit")
    @Mod.EventBusSubscriber(modid="wthit", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class HahaBorgeGoBrrrr {
        @SubscribeEvent
        static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(() -> ForgeWailaClient.registerConfigScreen());
        }
    }

    @Mod.EventBusSubscriber(modid="waila", value={Dist.CLIENT})
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void registerKeyMappings(RegisterKeyMappingsEvent event) {
            ForgeWailaClient.registerKeyBinds().forEach(arg_0 -> ((RegisterKeyMappingsEvent)event).register(arg_0));
        }

        @SubscribeEvent
        static void addReloadListener(RegisterClientReloadListenersEvent event) {
            event.registerReloadListener((PreparableReloadListener)new BuiltinThemeLoader());
        }

        @SubscribeEvent
        static void registerClientCommands(RegisterClientCommandsEvent event) {
            ((CommonCommand)new ForgeClientCommand()).register(event.getDispatcher());
        }

        @SubscribeEvent
        static void addGuiOverlayLayers(AddGuiOverlayLayersEvent event) {
            event.getLayeredDraw().add(TooltipRenderer.ID, TooltipRenderer::render);
        }

        @SubscribeEvent
        static void clientTick(TickEvent.ClientTickEvent.Post event) {
            ForgeWailaClient.onClientTick();
        }

        @SubscribeEvent
        static void itemTooltip(ItemTooltipEvent event) {
            ForgeWailaClient.onItemTooltip(event.getItemStack(), event.getToolTip());
        }

        @SubscribeEvent
        static void loggingOut(ClientPlayerNetworkEvent.LoggingOut event) {
            ForgeWailaClient.onServerLogout();
        }
    }
}

