/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.pipeline.MainTarget;
import com.mojang.blaze3d.platform.Window;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Rectangle;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.access.ClientAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IInstanceRegistry;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.gui.hud.ComponentRenderer;
import mcp.mobius.waila.gui.hud.InspectComponent;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.mixin.BossHealthOverlayAccess;
import mcp.mobius.waila.mixin.GameNarratorAccess;
import mcp.mobius.waila.registry.PluginAware;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.ProfilerUtil;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TooltipRenderer {
    public static final ResourceLocation ID = Waila.id("tooltip");
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static boolean started;
    private static String lastNarration;
    private static ITooltipComponent icon;
    private static int topOffset;
    public static int colonOffset;
    public static int colonWidth;
    public static State state;
    private static long lastFrame;
    @Nullable
    private static MainTarget framebuffer;
    private static int fbWidth;
    private static int fbHeight;

    public static void beginBuild(State state) {
        started = true;
        TooltipRenderer.state = state;
        TOOLTIP.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = Minecraft.getInstance().font.width(": ");
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        ObjectListIterator objectListIterator = tooltip.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            TooltipRenderer.add(line);
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        if (line.tag != null) {
            TOOLTIP.setLine(line.tag, line);
        } else {
            TOOLTIP.add(line);
        }
        for (ITooltipComponent component : line.components) {
            if (component instanceof InspectComponent) {
                InspectComponent wrapper = (InspectComponent)component;
                component = wrapper.actual;
            }
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipRenderer.icon = PluginConfig.CLIENT.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static Rectangle endBuild() {
        Preconditions.checkState((boolean)started);
        ClientAccessor accessor = ClientAccessor.INSTANCE;
        if (state.fireEvent()) {
            for (IInstanceRegistry.Entry<PluginAware<IEventListener>> entry : Registrar.get().eventListeners.get(Object.class)) {
                PluginAware<IEventListener> pa = entry.instance();
                IEventListener listener = pa.instance();
                TooltipRenderer.TOOLTIP.origin = pa;
                listener.onHandleTooltip(TOOLTIP, accessor, PluginConfig.CLIENT);
                TooltipRenderer.TOOLTIP.origin = null;
            }
        }
        Minecraft client = Minecraft.getInstance();
        Window window = client.getWindow();
        TooltipRenderer.narrateObjectName(client);
        float scale = state.getScale();
        int fw = 0;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.calculateFixedWidth();
            fw = Math.max(fw, line.getFixedWidth());
        }
        int w = 0;
        int h = 0;
        ObjectListIterator iterator = TOOLTIP.iterator();
        while (iterator.hasNext()) {
            Line line = (Line)iterator.next();
            line.calculateDynamicWidth(fw);
            line.calculateHeight();
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            if (lineH <= 0) {
                iterator.remove();
                continue;
            }
            w = Math.max(w, lineW);
            h += lineH + 1;
        }
        if (h > 0) {
            --h;
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = Mth.positiveCeilDiv((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        Padding padding = Padding.INSTANCE;
        padding.set(0);
        state.getTheme().setPadding(padding);
        w += padding.left + padding.right;
        h = Math.max(h, icon.getHeight()) + padding.top + padding.bottom;
        int windowW = (int)((float)window.getGuiScaledWidth() / scale);
        int windowH = (int)((float)window.getGuiScaledHeight() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = state.getXAnchor();
        IWailaConfig.Overlay.Position.Align.Y anchorY = state.getYAnchor();
        IWailaConfig.Overlay.Position.Align.X alignX = state.getXAlign();
        IWailaConfig.Overlay.Position.Align.Y alignY = state.getYAlign();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)state.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)state.getY();
        if (!state.bossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(((BossHealthOverlayAccess)client.gui.getBossOverlay()).wthit_events().size() * 19, window.getGuiScaledHeight() / 3 + 2);
        }
        RECT.get().setRect(Mth.floor((double)(x + 0.5)), Mth.floor((double)(y + 0.5)), w, h);
        started = false;
        return RECT.get();
    }

    public static void resetState() {
        state = null;
    }

    public static void render(GuiGraphics ctx, DeltaTracker delta) {
        try (ProfilerUtil.Impl ignored = ProfilerUtil.profile("wthit:render");){
            TooltipRenderer._render(ctx, delta);
        }
    }

    private static void _render(GuiGraphics ctx, DeltaTracker delta) {
        Minecraft client = Minecraft.getInstance();
        if (WailaClient.showFps) {
            String fpsString = client.getFps() + " FPS";
            int x1 = client.font.width(fpsString) + 2;
            int n = client.getWindow().getGuiScaledHeight();
            Objects.requireNonNull(client.font);
            int y0 = n - 9 - 1;
            Objects.requireNonNull(client.font);
            int y1 = y0 + 9 + 2;
            ctx.fill(0, y0, x1, y1, -1873784752);
            ctx.drawString(client.font, fpsString, 1, y0 + 1, -2039584, false);
        }
        if (state == null || !state.render()) {
            return;
        }
        int fps = state.getFps();
        TooltipRenderer.renderUncached(ctx, delta);
    }

    private static void renderUncached(GuiGraphics ctx, DeltaTracker delta) {
        try (ProfilerUtil.Impl ignored = ProfilerUtil.profile("wthit:render_uncached");){
            TooltipRenderer._renderUncached(ctx, delta);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void _renderUncached(GuiGraphics ctx, DeltaTracker delta) {
        void var13_20;
        ComponentRenderer renderer = ComponentRenderer.get();
        float scale = state.getScale();
        ctx.pose().pushMatrix();
        ctx.pose().scale(scale, scale);
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        if (state.fireEvent()) {
            EventCanceller canceller = EventCanceller.INSTANCE;
            canceller.setCanceled(false);
            for (IInstanceRegistry.Entry<PluginAware<IEventListener>> listener : Registrar.get().eventListeners.get(Object.class)) {
                listener.instance().instance().onBeforeTooltipRender(ctx, rect, ClientAccessor.INSTANCE, PluginConfig.CLIENT, canceller);
                if (!canceller.isCanceled()) continue;
                ctx.pose().popMatrix();
                return;
            }
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        Padding padding = Padding.INSTANCE;
        if (state.getBackgroundAlpha() > 0) {
            state.getTheme().renderTooltipBackground(ctx, x, y, width, height, state.getBackgroundAlpha(), delta);
        }
        ctx.nextStratum();
        int textX = x + padding.left;
        int textY = y + padding.top + topOffset;
        if (icon.getWidth() > 0) {
            textX += icon.getWidth() + 3;
        }
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.render(renderer, ctx, textX, textY, delta);
            textY += line.getHeight() + 1;
        }
        if (state.fireEvent()) {
            for (IInstanceRegistry.Entry entry : Registrar.get().eventListeners.get(Object.class)) {
                ((IEventListener)((PluginAware)entry.instance()).instance()).onAfterTooltipRender(ctx, rect, ClientAccessor.INSTANCE, PluginConfig.CLIENT);
            }
        }
        IWailaConfig.Overlay.Position.Align.Y iconPos = (IWailaConfig.Overlay.Position.Align.Y)((Object)PluginConfig.CLIENT.getEnum(WailaConstants.CONFIG_ICON_POSITION));
        int n = y + padding.top + Mth.ceil((double)((double)(height - (padding.top + padding.bottom) - icon.getHeight()) * iconPos.multiplier));
        if (iconPos == IWailaConfig.Overlay.Position.Align.Y.BOTTOM) {
            ++var13_20;
        }
        renderer.render(ctx, icon, x + padding.left, (int)var13_20, icon.getWidth(), icon.getHeight(), delta);
        ctx.pose().popMatrix();
    }

    private static void narrateObjectName(Minecraft client) {
        ITooltipComponent iTooltipComponent;
        if (!state.render()) {
            return;
        }
        Narrator narrator = ((GameNarratorAccess)client.getNarrator()).wthit_narrator();
        if (!narrator.active() || !state.enableTextToSpeech() || Minecraft.getInstance().screen instanceof ChatScreen) {
            return;
        }
        Line objectName = TOOLTIP.getLine(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && (iTooltipComponent = objectName.components.get(0)) instanceof WrappedComponent) {
            WrappedComponent component = (WrappedComponent)iTooltipComponent;
            String narrate = component.component.getString().replaceAll("\u00a7[a-z0-9]", "");
            if (!lastNarration.equalsIgnoreCase(narrate)) {
                CompletableFuture.runAsync(() -> narrator.say(narrate, true, 1.0f));
                lastNarration = narrate;
            }
        }
    }

    static {
        lastNarration = "";
        icon = EmptyComponent.INSTANCE;
        lastFrame = System.nanoTime();
        framebuffer = null;
    }

    public static interface State {
        public boolean render();

        public boolean fireEvent();

        public int getFps();

        public float getScale();

        public IWailaConfig.Overlay.Position.Align.X getXAnchor();

        public IWailaConfig.Overlay.Position.Align.Y getYAnchor();

        public IWailaConfig.Overlay.Position.Align.X getXAlign();

        public IWailaConfig.Overlay.Position.Align.Y getYAlign();

        public int getX();

        public int getY();

        public boolean bossBarsOverlap();

        public int getBackgroundAlpha();

        public ITheme getTheme();

        public boolean enableTextToSpeech();
    }

    private static enum Padding implements ITheme.Padding
    {
        INSTANCE;

        int top;
        int right;
        int bottom;
        int left;

        @Override
        public void set(int all) {
            this.set(all, all, all, all);
        }

        @Override
        public void set(int topBottom, int leftRight) {
            this.set(topBottom, leftRight, topBottom, leftRight);
        }

        @Override
        public void set(int top, int leftRight, int bottom) {
            this.set(top, leftRight, bottom, leftRight);
        }

        @Override
        public void set(int top, int right, int bottom, int left) {
            this.top = top;
            this.right = right;
            this.bottom = bottom;
            this.left = left;
        }
    }
}

