/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import mcp.mobius.waila.api.ICommonRegistrar;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.ProgressArrowComponent;
import mcp.mobius.waila.api.component.ProgressBarComponent;
import mcp.mobius.waila.api.data.ProgressData;
import mcp.mobius.waila.plugin.extra.data.ProgressDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ProgressProvider
extends DataProvider<ProgressData, ProgressDataImpl> {
    public static final ProgressProvider INSTANCE = new ProgressProvider();
    private static final Component ESTIMATED_TIME = Component.translatable((String)"tooltip.waila.extra.estimated_time");
    private static final String TIMER_MS = "%02d:%02d";
    private static final String TIMER_HMS = "%02d:%02d:%02d";

    private ProgressProvider() {
        super(ProgressData.TYPE, ProgressDataImpl.CODEC);
    }

    @Override
    protected void registerAdditions(ICommonRegistrar registrar, int priority) {
        registrar.featureConfig(ProgressData.CONFIG_TIME, false);
        registrar.localConfig(ProgressData.CONFIG_REPLACE_ITEMS, false);
        registrar.localConfig(ProgressData.CONFIG_BAR_HEIGHT, 1);
    }

    static boolean isProgressOnly(ProgressDataImpl progress, IPluginConfig config) {
        if (!config.getBoolean(ProgressData.CONFIG_REPLACE_ITEMS)) {
            return true;
        }
        if (!progress.input().isEmpty()) {
            return false;
        }
        return progress.output().isEmpty();
    }

    private void appendProgress(ITooltip tooltip, ProgressDataImpl progress, IPluginConfig config, float ratio) {
        ITooltipLine line = tooltip.setLine(ProgressData.ID);
        if (ProgressProvider.isProgressOnly(progress, config)) {
            line.with(new ProgressBarComponent(config.getInt(ProgressData.CONFIG_BAR_HEIGHT), -1, -7631989, ratio));
        } else {
            for (ItemStack stack : progress.input()) {
                if (stack.isEmpty()) continue;
                line.with(new ItemComponent(stack));
            }
            line.with(new ProgressArrowComponent(ratio));
            for (ItemStack stack : progress.output()) {
                if (stack.isEmpty()) continue;
                line.with(new ItemComponent(stack));
            }
        }
    }

    @Override
    protected void appendBody(ITooltip tooltip, ProgressDataImpl progress, IPluginConfig config, ResourceLocation objectId) {
        if (progress.hasTick) {
            int current = progress.currentTick;
            int max = progress.maxTick;
            int remaining = max - current;
            if (current == 0 || remaining >= max) {
                return;
            }
            this.appendProgress(tooltip, progress, config, (float)current / (float)max);
            if (config.getBoolean(ProgressData.CONFIG_TIME)) {
                int seconds = remaining / 20 + 1;
                int minutes = seconds / 60;
                int hours = minutes / 60;
                tooltip.setLine(ProgressData.CONFIG_TIME, new PairComponent(ESTIMATED_TIME, (Component)Component.literal((String)(hours > 0 ? TIMER_HMS.formatted(hours, minutes, seconds) : TIMER_MS.formatted(minutes %= 60, seconds %= 60)))));
            }
            ++progress.currentTick;
        } else {
            if (progress.ratio == 0.0f) {
                return;
            }
            this.appendProgress(tooltip, progress, config, progress.ratio);
        }
    }
}

