/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.gui.widget.value.IntInputValue;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.registry.Registrar;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class PluginConfigScreen
extends ConfigScreen {
    private static final String NO_CATEGORY = "no_category";
    private static final Map<ConfigEntry.Type<Object>, ConfigValueFunction<Object>> ENTRY_TO_VALUE = new HashMap<ConfigEntry.Type<Object>, ConfigValueFunction<Object>>();

    public PluginConfigScreen(class_437 parent) {
        super(parent, (class_2561)class_2561.method_43471((String)"gui.waila.plugin.settings"), PluginConfig::write, PluginConfig::reload);
    }

    private static <T> void register(ConfigEntry.Type<T> type, ConfigValueFunction<T> function) {
        ENTRY_TO_VALUE.put(type, function);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.minecraft, this.field_22789, this.field_22790, 32, this.field_22790 - 32, 26, PluginConfig::write);
        for (String namespace : PluginConfig.getNamespaces()) {
            String namespaceTlKey = "config.waila.plugin_" + namespace;
            Set<class_2960> keys = PluginConfig.getAllKeys(namespace);
            if (keys.isEmpty()) continue;
            CategoryEntry namespaceCategory = new CategoryEntry(namespaceTlKey);
            options.with(namespaceCategory);
            HashMap<String, CategoryEntry> categories = new HashMap<String, CategoryEntry>();
            categories.put(NO_CATEGORY, namespaceCategory);
            for (class_2960 key : keys) {
                String c;
                String categoryTlKey;
                ConfigEntry entry = PluginConfig.getEntry(key);
                if (entry.isAlias()) continue;
                String path = key.method_12832();
                String categoryKey = NO_CATEGORY;
                if (path.contains(".") && class_1074.method_4663((String)(categoryTlKey = namespaceTlKey + "." + (c = path.split("[.]", 2)[0]))) && !categories.containsKey(categoryKey = c)) {
                    CategoryEntry category = new CategoryEntry(categoryTlKey);
                    namespaceCategory.with(category);
                    categories.put(categoryKey, category);
                }
                CategoryEntry category = (CategoryEntry)((Object)categories.get(categoryKey));
                String entryTlKey = namespaceTlKey + "." + path;
                if (entry.getType().equals(ConfigEntry.PATH)) {
                    ButtonEntry button = new ButtonEntry(entryTlKey, "config.waila.open_file", 100, 20, b -> class_156.method_668().method_672(((Path)entry.getDefaultValue()).toFile()));
                    category.with(button);
                    continue;
                }
                ConfigValue<Object, ?> value = ENTRY_TO_VALUE.get(entry.getType()).create(key, entryTlKey, entry.getLocalValue(), entry.getDefaultValue(), entry::setLocalValue);
                value.setId(key.toString());
                if (entry.blocksClientEdit() && this.minecraft.method_1558() != null) {
                    if (entry.getServerValue() == null) {
                        value.disable(PacketSender.c2s().canSend(Packets.VERSION) ? "config.waila.server_missing_option" : "config.waila.server_missing_mod");
                        value.setValue(entry.getClientOnlyValue());
                    } else {
                        value.disable(entry.isMerged() ? "config.waila.server_disabled" : "config.waila.server_only");
                        value.setValue(entry.getServerValue());
                    }
                }
                category.with(value);
            }
        }
        return options;
    }

    static {
        PluginConfigScreen.register(ConfigEntry.BOOLEAN, (key, name, value, defaultValue, save) -> new BooleanValue(name, (boolean)value, (Boolean)defaultValue, save));
        PluginConfigScreen.register(ConfigEntry.INTEGER, (key, name, value, defaultValue, save) -> new IntInputValue(name, (Integer)value, (Integer)defaultValue, save, Registrar.get().intConfigFormats.get(key)));
        PluginConfigScreen.register(ConfigEntry.DOUBLE, (key, name, value, defaultValue, save) -> new InputValue<Double>(name, (Double)value, (Double)defaultValue, save, InputValue.DECIMAL));
        PluginConfigScreen.register(ConfigEntry.STRING, (key, name, value, defaultValue, save) -> new InputValue<String>(name, (String)value, (String)defaultValue, save, InputValue.ANY));
        PluginConfigScreen.register(ConfigEntry.ENUM, (key, name, value, defaultValue, save) -> new EnumValue(name, (Enum[])value.getDeclaringClass().getEnumConstants(), value, defaultValue, save));
    }

    @FunctionalInterface
    private static interface ConfigValueFunction<T> {
        public ConfigValue<T, ?> create(class_2960 var1, String var2, T var3, T var4, Consumer<T> var5);
    }
}

