/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.data.FluidData;
import net.minecraft.class_1058;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;

public class FluidDataImpl
extends FluidData.PlatformDependant<Object> {
    private final List<Entry<?>> entries;
    private final FluidData.PlatformTranslator<Object> proxy;
    private final FluidData.Unit unit;

    public FluidDataImpl(@Nullable FluidData.PlatformTranslator<Object> proxy, FluidData.Unit unit, int slotCountHint) {
        this.entries = slotCountHint == -1 ? new ArrayList() : new ArrayList(slotCountHint);
        this.proxy = proxy;
        this.unit = unit;
    }

    public FluidDataImpl(class_2540 buf) {
        this.proxy = null;
        this.unit = (FluidData.Unit)buf.method_10818(FluidData.Unit.class);
        int size = buf.method_10816();
        this.entries = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            int id = buf.method_10816();
            class_3611 fluid = (class_3611)class_2378.field_11154.method_10200(id);
            class_2487 nbt = buf.method_10798();
            double stored = buf.readDouble();
            double capacity = buf.readDouble();
            this.add(fluid, nbt, stored, capacity);
        }
    }

    @Override
    protected void implAdd(class_3611 fluid, @Nullable class_2487 nbt, double stored, double capacity) {
        this.entries.add(new Entry<class_3611>(fluid, nbt, stored, capacity));
    }

    @Override
    protected FluidData.PlatformTranslator<Object> translator() {
        return this.proxy;
    }

    @Override
    public void write(class_2540 buf) {
        buf.method_10817((Enum)this.unit);
        buf.method_10804(this.entries.size());
        for (Entry<?> entry : this.entries) {
            if (entry.isEmpty()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.method_42065((class_2359)class_2378.field_11154, entry.fluid);
            buf.method_10794(entry.nbt);
            buf.writeDouble(entry.stored);
            buf.writeDouble(entry.capacity);
        }
    }

    public FluidData.Unit unit() {
        return this.unit;
    }

    public List<Entry<?>> entries() {
        return this.entries;
    }

    public static class Entry<T extends class_3611>
    implements FluidData.FluidDescriptionContext<T> {
        private final T fluid;
        @Nullable
        private final class_2487 nbt;
        private final double stored;
        private final double capacity;

        private Entry(T fluid, @Nullable class_2487 nbt, double stored, double capacity) {
            this.fluid = fluid;
            this.nbt = nbt;
            this.stored = stored;
            this.capacity = capacity;
        }

        public boolean isEmpty() {
            return this.fluid == class_3612.field_15906 || this.stored <= 0.0;
        }

        @Override
        public T fluid() {
            return this.fluid;
        }

        @Override
        @Nullable
        public class_2487 nbt() {
            return this.nbt;
        }

        public double stored() {
            return this.stored;
        }

        public double capacity() {
            return this.capacity;
        }
    }

    public static class FluidDescription
    implements FluidData.FluidDescription {
        public static final Map<class_3611, FluidData.FluidDescriptor<class_3611>> FLUID_STATIC = new HashMap<class_3611, FluidData.FluidDescriptor<class_3611>>();
        public static final Map<Class<?>, FluidData.FluidDescriptor<class_3611>> FLUID_DYNAMIC = new HashMap();
        public static final Map<class_2248, FluidData.CauldronDescriptor> CAULDRON_STATIC = new HashMap<class_2248, FluidData.CauldronDescriptor>();
        public static final Map<Class<?>, FluidData.CauldronDescriptor> CAULDRON_DYNAMIC = new HashMap();
        private static final FluidDescription INSTANCE = new FluidDescription();
        private static final class_2561 UNKNOWN_FLUID_NAME = class_2561.method_43471((String)"tooltip.waila.extra.unknown_fluid");
        private static final FluidData.FluidDescriptor<class_3611> UNKNOWN_FLUID_DESC = (ctx, desc) -> {};
        private static final FluidData.CauldronDescriptor NULL_CAULDRON_DESC = state -> null;
        private class_1058 sprite;
        private int tint;
        private class_2561 name;

        public static FluidDescription getFluidDesc(Entry<?> entry) {
            Object fluid = entry.fluid();
            FluidData.FluidDescriptor<class_3611> descriptor = FLUID_STATIC.get(fluid);
            if (descriptor == null) {
                for (Class<?> clazz = fluid.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    descriptor = FLUID_DYNAMIC.get(clazz);
                    if (descriptor == null) continue;
                    FLUID_DYNAMIC.put(fluid.getClass(), descriptor);
                    break;
                }
            }
            if (descriptor == null) {
                descriptor = UNKNOWN_FLUID_DESC;
                FLUID_STATIC.put((class_3611)fluid, UNKNOWN_FLUID_DESC);
            }
            INSTANCE.sprite(class_310.method_1551().method_1554().method_4743().method_3335(class_2246.field_10382.method_9564()).method_4711()).tint(-1).name(UNKNOWN_FLUID_NAME);
            descriptor.describeFluid(entry, INSTANCE);
            return INSTANCE;
        }

        @Nullable
        public static FluidData getCauldronFluidData(class_2680 state) {
            class_2248 block = state.method_26204();
            FluidData.CauldronDescriptor getter = CAULDRON_STATIC.get(block);
            if (getter == null) {
                for (Class<?> clazz = block.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                    getter = CAULDRON_DYNAMIC.get(clazz);
                    if (getter == null) continue;
                    CAULDRON_DYNAMIC.put(block.getClass(), getter);
                    break;
                }
            }
            if (getter == null) {
                getter = NULL_CAULDRON_DESC;
                CAULDRON_STATIC.put(block, NULL_CAULDRON_DESC);
            }
            return getter.getCauldronFluidData(state);
        }

        public class_2561 name() {
            return this.name;
        }

        public class_1058 sprite() {
            return this.sprite;
        }

        public int tint() {
            return this.tint;
        }

        @Override
        public FluidDescription name(class_2561 name) {
            this.name = name;
            return this;
        }

        @Override
        public FluidDescription sprite(class_1058 sprite) {
            this.sprite = sprite;
            return this;
        }

        @Override
        public FluidDescription tint(int argb) {
            this.tint = argb;
            return this;
        }
    }
}

