/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.provider;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.ICommonAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipLine;
import mcp.mobius.waila.api.component.GrowingComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.harvest.component.ToolComponent;
import mcp.mobius.waila.plugin.harvest.config.HarvestDisplayMode;
import mcp.mobius.waila.plugin.harvest.config.Options;
import mcp.mobius.waila.plugin.harvest.tool.ToolTier;
import mcp.mobius.waila.plugin.harvest.tool.ToolType;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1922;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public enum HarvestProvider implements IBlockComponentProvider,
IEventListener
{
    INSTANCE;

    private static final class_2960 CLASSIC_HARVESTABLE;
    private static final class_2960 CLASSIC_EFFECTIVE_TOOL;
    private static final class_2960 CLASSIC_LEVEL;
    private static final class_2960 CLASSIC_MINIMAL;
    private static final ToolType UNBREAKABLE;
    public final Map<class_2680, List<ToolType>> toolsCache = new Reference2ObjectOpenHashMap();
    public final Map<class_2680, ToolTier> tierCache = new Reference2ObjectOpenHashMap();
    private int updateId = 0;
    private class_2680 state;
    private final List<ToolComponent> toolComponents = new ArrayList<ToolComponent>();
    private boolean renderComponents = false;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        HarvestDisplayMode harvestDisplayMode;
        ToolTier highestTier;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        if (accessor.getPlayer().method_7337() && !config.getBoolean(Options.CREATIVE)) {
            return;
        }
        this.updateId = accessor.getUpdateId();
        this.state = accessor.getBlockState();
        boolean unbreakable = this.state.method_26214((class_1922)accessor.getWorld(), accessor.getPosition()) < 0.0f;
        List<ToolType> tools = this.toolsCache.get(this.state);
        if (tools == null) {
            tools = new ArrayList<ToolType>();
            if (unbreakable) {
                tools.add(UNBREAKABLE);
            } else {
                for (ToolType toolType : ToolType.all()) {
                    if (!toolType.blockPredicate.test(this.state)) continue;
                    tools.add(toolType);
                }
                if (tools.isEmpty()) {
                    tools = List.of();
                }
            }
            this.toolsCache.put(this.state, tools);
        }
        if ((highestTier = this.tierCache.get(this.state)) == null) {
            highestTier = ToolTier.NONE;
            for (ToolTier tier : ToolTier.all()) {
                if (tier.tag == null || !this.state.method_26164(tier.tag)) continue;
                highestTier = tier;
            }
            this.tierCache.put(this.state, highestTier);
        }
        if ((harvestDisplayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE))) == HarvestDisplayMode.MODERN) {
            return;
        }
        class_1799 heldStack = accessor.getPlayer().method_31548().method_7391();
        if (harvestDisplayMode == HarvestDisplayMode.CLASSIC) {
            tooltip.setLine(CLASSIC_HARVESTABLE, (class_2561)class_2561.method_43473().method_10852((class_2561)this.getHarvestableSymbol(accessor, unbreakable)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"tooltip.waila.harvest.harvestable")));
            if (!tools.isEmpty() && !unbreakable) {
                tooltip.setLine(CLASSIC_EFFECTIVE_TOOL, new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.harvest.effective_tool"), (class_2561)HarvestProvider.getToolText(tools, heldStack)));
            }
            if (highestTier != ToolTier.NONE) {
                tooltip.setLine(CLASSIC_LEVEL, new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.harvest.level"), (class_2561)HarvestProvider.getTierText(highestTier, heldStack)));
            }
        } else if (harvestDisplayMode == HarvestDisplayMode.CLASSIC_MINIMAL) {
            class_5250 text = class_2561.method_43473();
            text.method_10852((class_2561)this.getHarvestableSymbol(accessor, unbreakable));
            if (!tools.isEmpty() && !unbreakable) {
                text.method_27693(" | ").method_10852((class_2561)HarvestProvider.getToolText(tools, heldStack));
                if (highestTier != ToolTier.NONE) {
                    text.method_27693(" | ");
                }
            }
            if (highestTier != ToolTier.NONE) {
                text.method_10852((class_2561)HarvestProvider.getTierText(highestTier, heldStack));
            }
            tooltip.setLine(CLASSIC_MINIMAL, (class_2561)text);
        }
    }

    @Override
    public void onHandleTooltip(ITooltip tooltip, ICommonAccessor accessor, IPluginConfig config) {
        this.renderComponents = false;
        if (!config.getBoolean(Options.ENABLED)) {
            return;
        }
        HarvestDisplayMode displayMode = (HarvestDisplayMode)((Object)config.getEnum(Options.DISPLAY_MODE));
        if (displayMode != HarvestDisplayMode.MODERN) {
            return;
        }
        if (this.updateId != accessor.getUpdateId()) {
            return;
        }
        List<ToolType> tools = this.toolsCache.get(this.state);
        ToolTier highestTier = this.tierCache.get(this.state);
        if (tools == null || highestTier == null || tools.isEmpty()) {
            return;
        }
        class_1799 heldStack = accessor.getPlayer().method_31548().method_7391();
        ITooltipLine line = tooltip.getLine(tooltip.getLineCount() - 1);
        line.with(GrowingComponent.INSTANCE);
        this.toolComponents.clear();
        for (ToolType tool : tools) {
            ToolComponent component;
            if (tool == UNBREAKABLE) {
                component = new ToolComponent(null, false);
            } else {
                class_1799 icon = tool.getIcon(highestTier);
                Boolean matches = null;
                if (this.state.method_29291()) {
                    class_1792 class_17922;
                    matches = tool.itemPredicate.test(heldStack);
                    if (highestTier != ToolTier.NONE && (class_17922 = heldStack.method_7909()) instanceof class_1831) {
                        class_1831 tiered = (class_1831)class_17922;
                        ToolTier heldTier = ToolTier.get(tiered.method_8022());
                        matches = matches != false && heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier);
                    }
                }
                component = new ToolComponent(icon, matches);
            }
            line.with(component);
            this.toolComponents.add(component);
        }
        this.renderComponents = true;
    }

    @Override
    public void onAfterTooltipRender(class_4587 matrices, Rectangle rect, ICommonAccessor accessor, IPluginConfig config) {
        if (!this.renderComponents) {
            return;
        }
        for (ToolComponent component : this.toolComponents) {
            component.actuallyRender(matrices, rect.y + rect.height - 13);
        }
    }

    @NotNull
    private class_5250 getHarvestableSymbol(IBlockAccessor accessor, boolean unbreakable) {
        return unbreakable || !accessor.getPlayer().method_7305(this.state) ? class_2561.method_43470((String)"\u2718").method_27692(class_124.field_1061) : class_2561.method_43470((String)"\u2714").method_27692(class_124.field_1060);
    }

    @NotNull
    private static class_5250 getToolText(List<ToolType> tools, class_1799 heldStack) {
        class_5250 toolText = class_2561.method_43473();
        Iterator<ToolType> toolIter = tools.iterator();
        while (toolIter.hasNext()) {
            ToolType tool = toolIter.next();
            if (tool == UNBREAKABLE) continue;
            toolText.method_10852((class_2561)tool.text.method_27661().method_27692(tool.itemPredicate.test(heldStack) ? class_124.field_1060 : class_124.field_1061));
            if (!toolIter.hasNext()) continue;
            toolText.method_27693(", ");
        }
        return toolText;
    }

    @NotNull
    private static class_5250 getTierText(ToolTier highestTier, class_1799 heldStack) {
        class_5250 tierText = class_1074.method_4663((String)highestTier.tlKey()) ? class_2561.method_43471((String)highestTier.tlKey()) : class_2561.method_43470((String)String.valueOf(highestTier.index));
        class_1792 class_17922 = heldStack.method_7909();
        if (class_17922 instanceof class_1831) {
            class_1831 tiered = (class_1831)class_17922;
            ToolTier heldTier = ToolTier.get(tiered.method_8022());
            tierText.method_27692(heldTier != null && heldTier.isBetterThanOrEqualTo(highestTier) ? class_124.field_1060 : class_124.field_1061);
        } else {
            tierText.method_27692(class_124.field_1061);
        }
        return tierText;
    }

    static {
        CLASSIC_HARVESTABLE = Options.rl("classic.harvestable");
        CLASSIC_EFFECTIVE_TOOL = Options.rl("classic.effective_tool");
        CLASSIC_LEVEL = Options.rl("classic.level");
        CLASSIC_MINIMAL = Options.rl("classic.minimal");
        UNBREAKABLE = new ToolType();
    }
}

