/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.gui.screen.TabbedConfigScreen;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.plugin.PluginLoader;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;

public class PluginToggleScreen
extends TabbedConfigScreen {
    public static final Component TITLE = Component.translatable((String)"gui.waila.plugin.toggle");
    private final Object2BooleanMap<ResourceLocation> initialValues = new Object2BooleanOpenHashMap();
    private final Object2BooleanMap<ResourceLocation> updatedValues = new Object2BooleanOpenHashMap();

    public PluginToggleScreen(Screen parent) {
        super(parent, CommonComponents.EMPTY);
    }

    private void askSave(Runnable then) {
        if (this.initialValues.equals(this.updatedValues)) {
            then.run();
            return;
        }
        this.minecraft.setScreen((Screen)new ConfirmScreen(accepted -> {
            if (!accepted) {
                then.run();
                return;
            }
            this.updatedValues.forEach((k, v) -> PluginInfo.get(k).setEnabled((boolean)v));
            IntegratedServer integratedServer = this.minecraft.getSingleplayerServer();
            if (integratedServer != null) {
                PluginLoader.reloadServerPlugins((MinecraftServer)integratedServer);
            } else {
                PluginLoader.reloadClientPlugins();
            }
            then.run();
        }, (Component)Component.translatable((String)"gui.waila.plugin.toggle"), (Component)Component.translatable((String)"gui.waila.plugin.toggle.confirm")));
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.minecraft, this.width, this.height, 24, this.height - 32, 26, () -> this.askSave(() -> super.onClose()));
        options.headerSeparator = false;
        List<PluginInfo> sorted = PluginInfo.getAll().stream().sorted((a, b) -> {
            boolean bIsWaila;
            ResourceLocation aId = a.getPluginId();
            ResourceLocation bId = b.getPluginId();
            boolean aIsWaila = aId.getNamespace().equals("waila");
            if (aIsWaila == (bIsWaila = bId.getNamespace().equals("waila"))) {
                return aId.toString().compareTo(bId.toString());
            }
            return aIsWaila ? -1 : 1;
        }).toList();
        for (final PluginInfo plugin : sorted) {
            ResourceLocation id = plugin.getPluginId();
            boolean enabled = plugin.isEnabled();
            this.initialValues.put((Object)id, enabled);
            this.updatedValues.put((Object)id, enabled);
            BooleanValue toggle = new BooleanValue(this, "", enabled, null, val -> this.updatedValues.put((Object)id, val.booleanValue())){

                @Override
                public MutableComponent getTitle() {
                    return Component.literal((String)plugin.getPluginId().toString());
                }

                @Override
                public Component getDescription() {
                    return IWailaConfig.get().getFormatter().modName(plugin.getModInfo().getName());
                }
            };
            if (plugin.isLocked()) {
                toggle.disable("gui.waila.plugin.toggle.locked");
            }
            options.with(toggle);
        }
        return options;
    }

    @Override
    public void changeTab(Runnable change) {
        this.options.save(false);
        this.askSave(change);
    }

    @Override
    public void onClose() {
    }
}

