/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import com.google.common.base.Preconditions;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.__internal__.IExtraService;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class FluidData
implements IData {
    public static final ResourceLocation ID = BuiltinDataUtil.rl("fluid");
    public static final ResourceLocation CONFIG_DISPLAY_UNIT = BuiltinDataUtil.rl("fluid.display_unit");

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(T fluid, FluidDescriptor<T> descriptor) {
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            Preconditions.checkArgument((flowing == flowing.m_5613_() ? 1 : 0) != 0, (Object)"Not a source fluid");
        }
        IExtraService.INSTANCE.setFluidDescFor(fluid, descriptor);
    }

    @ApiSide.ClientOnly
    public static <T extends Fluid> void describeFluid(Class<T> clazz, FluidDescriptor<T> descriptor) {
        IExtraService.INSTANCE.setFluidDescFor(clazz, descriptor);
    }

    public static void describeCauldron(Block block, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(block, descriptor);
    }

    public static void describeCauldron(Class<? extends Block> clazz, CauldronDescriptor descriptor) {
        IExtraService.INSTANCE.setCauldronDescFor(clazz, descriptor);
    }

    public static FluidData of(Unit unit) {
        return IExtraService.INSTANCE.createFluidData(null, unit, -1);
    }

    public static FluidData of(Unit unit, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(null, unit, slotCountHint);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), -1);
    }

    public static <S> PlatformDependant<S> of(PlatformTranslator<S> translator, int slotCountHint) {
        return IExtraService.INSTANCE.createFluidData(translator, translator.unit(), slotCountHint);
    }

    public FluidData add(Fluid fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
        Fluid fluid2;
        capacity = Math.max(capacity, 0.0);
        stored = Mth.m_14008_((double)stored, (double)0.0, (double)capacity);
        if (capacity == 0.0) {
            capacity = Double.POSITIVE_INFINITY;
        }
        if (fluid instanceof FlowingFluid) {
            FlowingFluid flowing = (FlowingFluid)fluid;
            fluid2 = flowing.m_5613_();
        } else {
            fluid2 = fluid;
        }
        Fluid source = fluid2;
        this.implAdd(source, nbt, stored, capacity);
        return this;
    }

    protected abstract PlatformTranslator<Object> translator();

    protected abstract void implAdd(Fluid var1, @Nullable CompoundTag var2, double var3, double var5);

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of() {
        return FluidData.of(Unit.MILLIBUCKETS);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="1.21")
    public static FluidData of(int slotCountHint) {
        return FluidData.of(Unit.MILLIBUCKETS, slotCountHint);
    }

    @ApiSide.ClientOnly
    @ApiStatus.OverrideOnly
    public static interface FluidDescriptor<T extends Fluid> {
        public void describeFluid(FluidDescriptionContext<T> var1, FluidDescription var2);
    }

    @ApiStatus.OverrideOnly
    public static interface CauldronDescriptor {
        @Nullable
        public FluidData getCauldronFluidData(BlockState var1);
    }

    @ApiStatus.Experimental
    @ApiStatus.OverrideOnly
    public static interface PlatformTranslator<T> {
        public Unit unit();

        public Fluid fluid(T var1);

        @Nullable
        public CompoundTag nbt(T var1);

        public double amount(T var1) throws UnsupportedOperationException;
    }

    public static enum Unit {
        MILLIBUCKETS("mB"),
        DROPLETS("dp");

        public final String symbol;

        public static double convert(Unit from, Unit to, double amount) {
            if (from == to) {
                return amount;
            }
            return switch (to) {
                default -> throw new IncompatibleClassChangeError();
                case MILLIBUCKETS -> amount / 81.0;
                case DROPLETS -> amount * 81.0;
            };
        }

        private Unit(String symbol) {
            this.symbol = symbol;
        }
    }

    @ApiStatus.NonExtendable
    public static abstract class PlatformDependant<T>
    extends FluidData {
        public PlatformDependant<T> add(T stack, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(stack), translator.nbt(stack), translator.amount(stack), capacity);
        }

        public PlatformDependant<T> add(T variant, double stored, double capacity) {
            PlatformTranslator<Object> translator = this.translator();
            return this.add(translator.fluid(variant), translator.nbt(variant), stored, capacity);
        }

        @Override
        public PlatformDependant<T> add(Fluid fluid, @Nullable CompoundTag nbt, double stored, double capacity) {
            super.add(fluid, nbt, stored, capacity);
            return this;
        }
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescriptionContext<T extends Fluid> {
        public T fluid();

        @Nullable
        public CompoundTag nbt();
    }

    @ApiSide.ClientOnly
    @ApiStatus.NonExtendable
    public static interface FluidDescription {
        public FluidDescription name(Component var1);

        public FluidDescription sprite(TextureAtlasSprite var1);

        public FluidDescription tint(int var1);
    }
}

