/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.Futures;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public enum PetOwnerProvider implements IEntityComponentProvider
{
    INSTANCE;

    static final Supplier<HttpClient> HTTP;
    static final Map<UUID, Future<Component>> NAMES;
    static final Component UNKNOWN;
    static final Component LOADING;
    static final Component KEY;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PET_OWNER)) {
            Object entity = accessor.getEntity();
            UUID uuid = null;
            if (entity instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)entity;
                uuid = horse.m_30615_();
            } else if (entity instanceof OwnableEntity) {
                OwnableEntity ownableEntity = (OwnableEntity)entity;
                uuid = ownableEntity.m_21805_();
            }
            if (uuid == null) {
                return;
            }
            Component name = LOADING;
            if (NAMES.containsKey(uuid)) {
                Future<Component> future = NAMES.get(uuid);
                if (future.isDone()) {
                    name = (Component)Futures.getUnchecked(future);
                }
            } else {
                NAMES.put(uuid, this.requestOwner(uuid));
            }
            if (name != UNKNOWN && name != LOADING || !config.getBoolean(Options.PET_HIDE_UNKNOWN_OWNER)) {
                tooltip.setLine(Options.PET_OWNER, new PairComponent(KEY, name));
            }
        }
    }

    private Future<Component> requestOwner(UUID uuid) {
        return ((CompletableFuture)HTTP.get().sendAsync(HttpRequest.newBuilder().uri(URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid))).GET().build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8)).thenApplyAsync(res -> {
            String nameStr;
            JsonObject object;
            JsonElement element = JsonParser.parseString((String)((String)res.body()));
            if (element.isJsonObject() && (object = element.getAsJsonObject()).has("name") && (element = object.get("name")).isJsonPrimitive() && !(nameStr = element.getAsString()).isBlank()) {
                return Component.m_237113_((String)nameStr);
            }
            return UNKNOWN;
        })).handle((component, throwable) -> {
            if (component != null) {
                return component;
            }
            if (throwable != null) {
                throwable.printStackTrace();
            }
            return UNKNOWN;
        });
    }

    static {
        HTTP = Suppliers.memoize(HttpClient::newHttpClient);
        NAMES = new HashMap<UUID, Future<Component>>();
        UNKNOWN = Component.m_237113_((String)"???");
        LOADING = Component.m_237115_((String)"tooltip.waila.owner.loading").m_130940_(ChatFormatting.ITALIC);
        KEY = Component.m_237115_((String)"tooltip.waila.owner");
    }
}

