/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

@ApiSide.ClientOnly
public class HealthComponent
extends GuiComponent
implements ITooltipComponent {
    private final int health;
    private final int iconCount;
    private final int lineWidth;
    private final boolean absorption;

    public HealthComponent(float health, float maxHealth, int maxPerLine, boolean absorption) {
        this.health = Mth.m_14167_((float)health);
        this.iconCount = Mth.m_184652_((int)Mth.m_14167_((float)Math.max(health, maxHealth)), (int)2);
        this.lineWidth = Math.min(this.iconCount, maxPerLine);
        this.absorption = absorption;
    }

    @Override
    public int getWidth() {
        return this.lineWidth * 8 + 1;
    }

    @Override
    public int getHeight() {
        return Mth.m_184652_((int)this.iconCount, (int)this.lineWidth) * 3 + 6;
    }

    @Override
    public void render(PoseStack matrices, int x, int y, float delta) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        RenderSystem.m_69478_();
        RenderSystem.m_69453_();
        int filled = this.health / 2 - 1;
        int half = filled + this.health % 2;
        for (int i = this.iconCount - 1; i >= 0; --i) {
            int ix = x + i % this.lineWidth * 8;
            int iy = y + i / this.lineWidth * 3;
            this.m_93228_(matrices, ix, iy, 16, 0, 9, 9);
            if (i <= filled) {
                this.m_93228_(matrices, ix, iy, this.absorption ? 160 : 52, 0, 9, 9);
                continue;
            }
            if (i != half) continue;
            this.m_93228_(matrices, ix, iy, this.absorption ? 169 : 61, 0, 9, 9);
        }
        RenderSystem.m_69461_();
    }
}

