/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.access;

import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataReader;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public enum DataReader implements IDataReader
{
    SERVER,
    CLIENT;

    public static final IDataReader NOOP;
    private CompoundTag raw;
    private final Map<ResourceLocation, IData> typed = new HashMap<ResourceLocation, IData>();
    private boolean clean;

    private DataReader() {
        this.reset(null);
    }

    public void reset(@Nullable CompoundTag raw) {
        if (this.clean && raw == null) {
            return;
        }
        this.raw = raw == null ? new CompoundTag() : raw;
        this.clean = raw == null;
        this.typed.clear();
    }

    @Override
    public CompoundTag raw() {
        return this.raw;
    }

    @Override
    @Nullable
    public <D extends IData> D get(IData.Type<D> type) {
        return (D)this.typed.get(type.id());
    }

    @Override
    public <D extends IData> void invalidate(IData.Type<D> type) {
        this.typed.remove(type.id());
    }

    public void add(IData data) {
        this.clean = false;
        this.typed.put(data.type().id(), data);
    }

    static {
        NOOP = new IDataReader(){
            private static final CompoundTag TAG = new CompoundTag();

            @Override
            public CompoundTag raw() {
                return TAG;
            }

            @Override
            @Nullable
            public <D extends IData> D get(IData.Type<D> type) {
                return null;
            }

            @Override
            public <D extends IData> void invalidate(IData.Type<D> type) {
            }
        };
    }
}

