/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import java.util.Objects;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.__internal__.ApiSide;
import mcp.mobius.waila.api.util.WNumbers;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.joml.Matrix3x2fStack;

@ApiSide.ClientOnly
public class ItemComponent
implements ITooltipComponent {
    public static final ItemComponent EMPTY = new ItemComponent(ItemStack.EMPTY);
    public final ItemStack stack;

    public ItemComponent(ItemStack stack) {
        this.stack = stack;
    }

    public ItemComponent(ItemLike item) {
        this(new ItemStack(item));
    }

    @Override
    public int getWidth() {
        return this.stack.isEmpty() ? 0 : 18;
    }

    @Override
    public int getHeight() {
        return this.stack.isEmpty() ? 0 : 18;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        ctx.renderItem(this.stack, x + 1, y + 1);
        ItemComponent.renderItemDecorations(ctx, this.stack, x + 1, y + 1);
    }

    static void renderItemDecorations(GuiGraphics ctx, ItemStack stack, int x, int y) {
        Minecraft client = Minecraft.getInstance();
        int count = stack.getCount();
        ctx.renderItemDecorations(client.font, stack, x + 1, y + 1, "");
        if (count <= 1) {
            return;
        }
        String countText = WNumbers.suffix(count);
        int actualW = client.font.width(countText);
        float scale = actualW <= 16 ? 1.0f : 16.0f / (float)actualW;
        Matrix3x2fStack pose = ctx.pose();
        pose.pushMatrix();
        pose.scale(scale, scale);
        Font font = client.font;
        int n = (int)(((float)(x + 17) - (float)actualW * scale) / scale);
        float f = y + 17;
        Objects.requireNonNull(client.font);
        ctx.drawString(font, countText, n, (int)((f - 9.0f * scale) / scale), -1);
        pose.popMatrix();
    }
}

