/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.BarComponent;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.render.TextureSetup;
import net.minecraft.client.gui.render.state.GuiElementRenderState;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fStack;
import org.joml.Matrix3x2fc;

public class SpriteBarComponent
implements ITooltipComponent {
    private final float ratio;
    private final ResourceLocation texture;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;
    private final int spriteTint;
    private final int regionWidth;
    private final int regionHeight;
    private final Component text;

    public SpriteBarComponent(float ratio, ResourceLocation texture, float u0, float u1, float v0, float v1, int regionWidth, int regionHeight, int tint, Component text) {
        this.ratio = ratio;
        this.texture = texture;
        this.u0 = u0;
        this.u1 = u1;
        this.v0 = v0;
        this.v1 = v1;
        this.spriteTint = tint;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.text = text;
    }

    public SpriteBarComponent(float ratio, TextureAtlasSprite sprite, int regionWidth, int regionHeight, int tint, Component text) {
        this(ratio, sprite.atlasLocation(), sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), regionWidth, regionHeight, tint, text);
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.getInstance().font.width((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        Matrix3x2fStack ps = ctx.pose();
        BarComponent.renderBar(ctx, x, y, 100, 0.0f, -5592406);
        int mw = (int)(100.0f * this.ratio);
        if (mw > 0) {
            int mx = x + mw;
            int my = y + 11;
            ctx.enableScissor(x + 1, y + 1, mx - 1, my - 1);
            ps.pushMatrix();
            WRenders.state(ctx).submitGuiElement((GuiElementRenderState)new ForegroundRenderState(new Matrix3x2f((Matrix3x2fc)ps), WRenders.scissor(ctx), new ScreenRectangle(x, y, mw, 11), mx, my));
            ps.popMatrix();
            ctx.disableScissor();
        }
        ctx.nextStratum();
        BarComponent.renderText(ctx, this.text, x, y);
    }

    private class ForegroundRenderState
    implements GuiElementRenderState {
        final Matrix3x2f pose;
        final ScreenRectangle scissorArea;
        final ScreenRectangle bounds;
        final TextureSetup textureSetup;
        final int mx;
        final int my;

        private ForegroundRenderState(Matrix3x2f pose, ScreenRectangle scissorArea, ScreenRectangle bounds, int mx, int my) {
            this.pose = pose;
            this.scissorArea = scissorArea;
            this.bounds = bounds;
            this.mx = mx;
            this.my = my;
            this.textureSetup = TextureSetup.singleTexture((GpuTextureView)Minecraft.getInstance().getTextureManager().getTexture(SpriteBarComponent.this.texture).getTextureView());
        }

        public void buildVertices(VertexConsumer buffer) {
            for (int px1 = this.bounds.left(); px1 < this.mx; px1 += SpriteBarComponent.this.regionWidth) {
                int px2 = px1 + SpriteBarComponent.this.regionWidth;
                for (int py1 = this.bounds.top(); py1 < this.my; py1 += SpriteBarComponent.this.regionHeight) {
                    int py2 = py1 + SpriteBarComponent.this.regionHeight;
                    buffer.addVertexWith2DPose(this.pose, (float)px1, (float)py2).setUv(SpriteBarComponent.this.u0, SpriteBarComponent.this.v1).setColor(SpriteBarComponent.this.spriteTint);
                    buffer.addVertexWith2DPose(this.pose, (float)px2, (float)py2).setUv(SpriteBarComponent.this.u1, SpriteBarComponent.this.v1).setColor(SpriteBarComponent.this.spriteTint);
                    buffer.addVertexWith2DPose(this.pose, (float)px2, (float)py1).setUv(SpriteBarComponent.this.u1, SpriteBarComponent.this.v0).setColor(SpriteBarComponent.this.spriteTint);
                    buffer.addVertexWith2DPose(this.pose, (float)px1, (float)py1).setUv(SpriteBarComponent.this.u0, SpriteBarComponent.this.v0).setColor(SpriteBarComponent.this.spriteTint);
                }
            }
        }

        public RenderPipeline pipeline() {
            return RenderPipelines.GUI_TEXTURED;
        }

        public TextureSetup textureSetup() {
            return this.textureSetup;
        }

        @Nullable
        public ScreenRectangle scissorArea() {
            return this.scissorArea;
        }

        @Nullable
        public ScreenRectangle bounds() {
            return this.bounds;
        }
    }
}

